@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
@if(session('error'))

@endif


<!-- Page Sidebar Ends-->
<div class="page-body">

    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">اضــــافة عرض جديــــد</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">الرئيســـــية</a></li>
                        <li class="breadcrumb-item"> <a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">المنتجــــات</a> </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="bookmark">

                    </div>
                </div>
            </div>
        </div>
    </div>
    @if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">اضافـــــــة عرض جديـــد</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" method="POST" enctype="multipart/form-data"
                            action="{{ route('admin.offers.store') }}">
                            @csrf
                            <div class="col-sm-12 col-xl-12 xl-100">
                                <div class="card">
                                    <div class="card-body">
                                        <ul class="nav nav-tabs" id="icon-tab" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link active" id="icon-home-tab" data-bs-toggle="tab"
                                                    href="#icon-home" role="tab" aria-controls="icon-home"
                                                    aria-selected="true" style="font-family: 'Cairo', sans-serif;">
                                                    اللغة العربية
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" id="profile-icon-tab" data-bs-toggle="tab"
                                                    href="#profile-icon" role="tab" aria-controls="profile-icon"
                                                    aria-selected="false" style="font-family: 'Cairo', sans-serif;">
                                                    اللغة الانجليزية
                                                </a>
                                            </li>
                                        </ul>
                                        <br>
                                        <div class="tab-content" id="icon-tabContent">
                                            <!-- Arabic Tab -->
                                            <div class="tab-pane fade show active" id="icon-home" role="tabpanel"
                                                aria-labelledby="icon-home-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label for="name_ar" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            اسم المنتج باللغة العربية
                                                        </label>
                                                        <input name="name_ar" class="form-control" id="name_ar"
                                                            type="text" value="" required>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for="short_details_ar" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            وصف قصير باللغة العربية
                                                        </label>
                                                        <input name="details_ar" class="form-control"
                                                            id="short_details_ar" type="text" value="" required>
                                                    </div>
                                                </div>
                                                <br>
                                               
                                            </div>
                                            <!-- English Tab -->
                                            <div class="tab-pane fade" id="profile-icon" role="tabpanel"
                                                aria-labelledby="profile-icon-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label for="name_en" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            اسم المنتج باللغة الإنجليزية
                                                        </label>
                                                        <input name="name_en" class="form-control" id="name_en"
                                                            type="text" value="" required>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for="short_details_en" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            وصف قصير باللغة الإنجليزية
                                                        </label>
                                                        <input name="details_en" class="form-control"
                                                            id="details_en" type="text" value="" required>
                                                    </div>
                                                </div>
                                               
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Product Info Section -->
                       

                            <div class="row g-3">
                               
                                <div class="col-md-3">
                                    <label for="current_price" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">سعر المنتج </label>
                                    <input name="price" class="form-control" id="price" type="number"
                                        value="" required>
                                </div>
                                 <div class="col-md-3">
                                    <label for="quantity" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">الكمية</label>
                                    <input name="quantity" class="form-control" id="quantity" type="number" value=""
                                        required>
                                </div>


                                <div class="col-md-3">
                                    <label for="CategoryID" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">اسم القسم</label>
                                    <div class="box dropdown-content">
                                        <select name="category_id" id="category_id" class="form-control" required>
                                            <option value="" disabled>اختر القسم</option>
                                            @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{
                                                $category->getTranslation('name','ar') ??null }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                              <div class="col-md-3">
                                    <label class="mr-sm-2">اسم الماركة</label>
                                    <select name="brand_ids[]" id="brand_id" class="form-control" multiple required>
                                        @foreach ($brands as $brand)
                                            <option value="{{ $brand->id }}">
                                                {{ $brand->name['ar']}}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                               <div class="col-md-3">
                                    <label class="mr-sm-2">اسم الموديل</label>
                                    <select name="model_ids[]" id="model_id" class="form-control" multiple required>
                                    </select>
                                </div>

                                  <div class="col-md-3">
                                    <label for="quantity" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">بلد المنشأ</label>
                                    <input name="origin_country" class="form-control" id="origin_country" type="text" value=""
                                        required>
                                </div>
                                  <div class="col-md-3">
                                    <label for="quantity" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">فترة الضمان</label>
                                    <input name="warranty_period" class="form-control" id="warranty_period" type="text" value=""
                                        required>
                                </div>

                            <br>
                            <div class="row g-3">
                               
                                 <div class="col-md-3">
                                    <label for="CategoryID" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">اسم المورد</label>
                                    <div class="box dropdown-content">
                                        <select name="vendor_id" id="vendor_id" class="form-control" required>
                                            <option value="" disabled>اختر المورد</option>
                                            @foreach ($vendores as $vendor)
                                            <option value="{{ $vendor->id }}">{{
                                                $vendor->getTranslation('name','ar') ??null }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                 <div class="col-md-3">
                                    <label>تفعيل</label>
                                    <select name="is_active" class="form-control">
                                        <option value="1">نعم</option>
                                        <option value="0">لا</option>
                                    </select>
                                </div>
                            
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label for="start_time" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">
                                        تاريخ ووقت بدء العرض
                                    </label>
                                    <input type="datetime-local" name="start_time" id="start_time" class="form-control" value="{{ old('start_time') }}" required>
                                    @error('start_time')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="end_time" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">
                                        تاريخ ووقت انتهاء العرض
                                    </label>
                                    <input type="datetime-local" name="end_time" id="end_time" class="form-control" value="{{ old('end_time') }}" required>
                                    @error('end_time')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="quantity" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">نسبة الخصم</label>
                                    <input name="discount_percent" class="form-control" id="quantity" type="number" value=""
                                        required>
                                </div>

                           </div>

                            <div class="row g-3">
                               
                                <div class="col-md-8 mb-5">
                                    <label for="images" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">معرض
                                        الصور</label>
                                    <input name="images[]" class="form-control" type="file" accept="image/*" multiple>
                                </div>
                            </div>

                            <button class="btn btn-primary" type="submit">حفـــظ</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
@include('admin.layouts.js')


<script>
    $(document).ready(function() {
       $('#brand_id').on('change', function () {

    let brandIds = $(this).val(); // ARRAY

    $('#model_id').empty();

    if (brandIds && brandIds.length > 0) {
        $.ajax({
            url: '/admin/get-models-by-brands',
            type: 'post',
            data: {
                brand_ids: brandIds,
                _token: '{{ csrf_token() }}'
            },
            success: function (models) {
                models.forEach(function (model) {
                    $('#model_id').append(
                        `<option value="${model.id}">
                            ${model.name.ar}
                        </option>`
                    );
                });
            }
        });
    }
});

    });
</script>
@endsection