@extends('admin.layouts.master')

@section('title', 'تعديل العرض')

@section('css')
    @include('admin.layouts.css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
@endsection

@section('body')
 <script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

    <div class="page-body">
        <div class="container-fluid">
            <div class="page-header">
                <div class="row">
                    <div class="col-sm-6">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.products.index') }}">عـــروض المنتجات</a></li>
                            <li class="breadcrumb-item active">تعديل العرض</li>
                        </ol>
                    </div>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
                </div>
            @endif

            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-header pb-0"><h5>تعديل منتج</h5></div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('admin.offers.update', $product->id) }}" enctype="multipart/form-data">
                                @csrf
                                @method('PATCH')

                                {{-- الاسم --}}
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label>اسم المنتج (عربي)</label>
                                        <input type="text" name="name_ar" class="form-control" value="{{ old('name_ar', $product->getTranslation('name', 'ar')) }}" required>
                                        @error('name_ar') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-md-6">
                                        <label>اسم المنتج (إنجليزي)</label>
                                        <input type="text" name="name_en" class="form-control" value="{{ old('name_en', $product->getTranslation('name', 'en')) }}" required>
                                        @error('name_en') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>

                                {{-- السعر والكمية --}}
                                <div class="row g-3 mt-3">
                                    <div class="col-md-4">
                                        <label>السعر</label>
                                        <input type="number" step="0.01" name="price" class="form-control" value="{{ old('price', $product->price) }}" required>
                                        @error('price') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-md-4">
                                        <label>الكمية</label>
                                        <input type="number" name="stock" class="form-control" value="{{ old('stock', $product->stock) }}" required>
                                        @error('stock') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-md-4">
                                        <label>بلد المنشأ</label>
                                        <input name="origin_country" class="form-control" value="{{ old('origin_country', $product->origin_country) }}" required>
                                    </div>
                                </div>

                                {{-- الضمان و القسم --}}
                                <div class="row g-3 mt-3">
                                    <div class="col-md-4">
                                        <label>فترة الضمان</label>
                                        <input name="warranty_period" class="form-control" value="{{ old('warranty_period', $product->warranty_period) }}" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label>القسم</label>
                                        <select name="category_id" class="form-control" required>
                                            <option disabled selected>اختر القسم</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>
                                                    {{ $category->getTranslation('name', 'ar') }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('category_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>

                                {{-- الوصف والماركة والموديل --}}
                                <div class="row g-3 mt-3">
                                    <div class="col-md-6">
                                        <label>الوصف</label>
                                        <textarea name="description" class="form-control">{{ old('description', $product->description) }}</textarea>
                                        @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-md-3">
                                        <label>ماركة السيارة</label>
                                        <select name="brand_id" id="brand_id" class="form-control" required>
                                            <option value="">اختر الماركة</option>
                                            @foreach ($brands as $brand)
                                                <option value="{{ $brand->id }}" {{ old('brand_id', $product->brand_id) == $brand->id ? 'selected' : '' }}>
                                                    {{ $brand->name['ar'] }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('brand_id') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-md-3">
                                        <label>موديل السيارة</label>
                                        <select name="model_id" id="model_id" class="form-control" required>
                                            <option value="{{ $product->model->id }}">
                                                {{ $product->model->getTranslation('name','ar') }}
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                 <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label for="start_time" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">
                                        تاريخ ووقت بدء العرض
                                    </label>
                                    <input type="date" name="start_time" id="start_time" class="form-control" value="{{  \Illuminate\Support\Carbon::parse($product->offer_starts_at)->format('Y-m-d')   }}" required>
                                    @error('start_time')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="end_time" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">
                                        تاريخ ووقت انتهاء العرض
                                    </label>
                                    <input type="date" name="end_time" id="end_time" class="form-control" value="{{  \Illuminate\Support\Carbon::parse($product->offer_ends_at)->format('Y-m-d')  }}" required>
                                    @error('end_time')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="quantity" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">نسبة الخصم</label>
                                    <input name="discount_percent" class="form-control" id="quantity" type="number" value="{{$product->discount_percent}}"
                                        required>
                                </div>

                           </div>


                                {{-- الصور والحالة --}}
                                <div class="row g-3 mt-3">
                                    <div class="col-md-6">
                                        <label>صور المنتج</label>
                                        <input type="file" name="images[]" class="form-control" accept="image/*" multiple>
                                        @error('images') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-md-6">
                                        <label>الحالة</label>
                                        <select name="is_active" class="form-control" required>
                                            <option value="1" {{ old('is_active', $product->is_active) == 1 ? 'selected' : '' }}>مفعل</option>
                                            <option value="0" {{ old('is_active', $product->is_active) == 0 ? 'selected' : '' }}>غير مفعل</option>
                                        </select>
                                        @error('is_active') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <button class="btn btn-outline-info mb-2" type="button" id="toggleOldImages">عرض صور المنتج القديمة</button>
                                    <div id="oldImagesGallery" class="row d-none">
                                        @foreach($product->images as $image)
                                            <div class="col-md-3 position-relative mb-3">
                                                <img src="{{ asset('storage/' . $image->path) }}"
                                                    class="img-fluid rounded border"
                                                    style="width: 100%; height: 180px; object-fit: cover;"
                                                    alt="صورة المنتج">

                                                <button type="button"
                                                    class="btn btn-sm btn-danger delete-image-btn"
                                                    data-id="{{ $image->id }}"
                                                    style="position: absolute; top: 10px; right: 10px;">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>

                                {{-- زر الحفظ --}}
                                <div class="row g-3 mt-4">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                    </div>
                                </div>
                            </form>
                        </div> <!-- card-body -->
                    </div> <!-- card -->
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @include('admin.layouts.js')
    <script>
        $(document).ready(function () {
            $('#brand_id').on('change', function () {
                var brandId = $(this).val();
                if (brandId) {
                    $.ajax({
                        url: '/admin/get-models-by-brand/' + brandId,
                        type: 'GET',
                        success: function (data) {
                            $('#model_id').empty().append('<option value="">اختر الموديل</option>');
                            $.each(data, function (key, model) {
                                $('#model_id').append('<option value="' + model.id + '">' + model.name['ar'] + '</option>');
                            });
                        }
                    });
                } else {
                    $('#model_id').empty().append('<option value="">اختر الموديل</option>');
                }
            });
        });

        $('#toggleOldImages').click(function () {
            $('#oldImagesGallery').toggleClass('d-none');
        });
    </script>
@endsection