@extends('admin.layouts.master')

@section('title', 'إدارة المنتجات')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>العــــروض</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">عروض المنتجات</li>
                    </ol>
                </div>
                <div class="col-sm-6 text-end">
                    <a href="{{ route('admin.offers.create') }}" class="btn btn-success btn-lg">إضافة عرض  جديد</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card p-3">
            <div class="table-responsive">
                    <table dir="rtl" class="display datatables" id="dt-plugin-method">
                    <thead>
                        <tr>
                            
                            <th style="min-width: 40px;">#</th>
                             <th style="min-width: 150px;">الاسم</th>
                            <th style="min-width: 120px;">العنوان</th>
                            <th style="min-width: 100px;">السعر الحالي</th>
                            <th style="min-width: 100px;">السعر القديم</th>
                            <th style="min-width: 80px;">الكمية</th>
                            <th style="min-width: 100px;">القسم</th>
                            <th style="min-width: 120px;">معرض الصور</th>

                          
                            <th style="min-width: 100px;">تاريخ الإضافة</th>
                            <th style="min-width: 120px;">الإجراءات</th>


                        </tr>
                    </thead>
                    <tbody>
                        @foreach($offers as $product)
                        <tr>
                            <td>{{ $loop->iteration }}</td>

                           

                            <td>{{ $product->getTranslation('name', 'ar') ?? 'غير متوفر' }}</td>

                            <td>
                                @if($product->description)
                                    {{ Str::limit(strip_tags($product->description), 50) }}
                                @else
                                    <span>غير متوفر</span>
                                @endif
                            </td>

                            <td>
                                @if(is_numeric($product->price))
                                    {{ number_format((float)$product->price, 2) }} ج.م
                                @else
                                    غير متوفر
                                @endif
                            </td>
                            <td>
                                @if($product->discount_percent)
                                    {{ number_format($product->price * (1 + $product->discount_percent / 100)) . ' ج.م' }}
                                @else
                                    <span>لا يوجد خصم</span>
                                @endif
                            </td>

                            <td>{{ $product->stock ?? 'غير متوفر' }}</td>

                            <td>{{ optional($product->category)->getTranslation('name', 'ar') ?? 'غير محدد' }}</td>

                            <td>
                                @if($product->images->isNotEmpty())
                                    <img src="{{ asset('storage/' . $product->images->first()->path) }}" alt="معرض الصور" width="70">
                                @else
                                    <span>لا يوجد</span>
                                @endif
                            </td>

                         

                            <td>{{ $product->created_at ? $product->created_at->format('Y-m-d') : 'غير محدد' }}</td>

                            <td>
                                <a href="{{ route('admin.offers.edit', $product->id) }}" class="btn btn-success btn-sm">
                                    <i class="fa fa-edit"></i> تعديل
                                </a>
                                <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $product->id }}">
                                    <i class="fa fa-trash"></i> حذف
                                </button>
                                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#updateStatusModal{{ $product->id }}">
                                    <i class="fa fa-bullhorn"></i> تحديث الحالة
                                </button>
                            </td>
                        </tr>

                        <!-- Delete Modal -->
                        <div class="modal fade" id="deleteModal{{ $product->id }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <form action="{{ route('admin.products.destroy', $product->id) }}" method="POST" class="modal-content">
                                    @csrf
                                    @method('DELETE')
                                    <div class="modal-header">
                                        <h5 class="modal-title">تأكيد حذف المنتج</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        هل أنت متأكد أنك تريد حذف المنتج "{{ $product->getTranslation('name', 'ar') }}"؟
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                        <button type="submit" class="btn btn-danger">حذف</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Update Status Modal -->
                      {{--   <div class="modal fade" id="updateStatusModal{{ $product->id }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <form action="{{ route('admin.products.updateStatus', $product->id) }}" method="POST" class="modal-content">
                                    @csrf
                                    @method('PUT')
                                    <div class="modal-header">
                                        <h5 class="modal-title">تحديث حالة النشر</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <label>اختر الحالة:</label>
                                        <select name="status_active_id" class="form-select" required>
                                            <option value="1" {{ $product->status_active_id == 1 ? 'selected' : '' }}>معلق</option>
                                            <option value="2" {{ $product->status_active_id == 2 ? 'selected' : '' }}>موافق عليه</option>
                                            <option value="3" {{ $product->status_active_id == 3 ? 'selected' : '' }}>مرفوض</option>
                                        </select>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                        <button type="submit" class="btn btn-success">تحديث</button>
                                    </div>
                                </form>
                            </div>
                        </div> --}}
                        <div class="modal fade" id="updateStatusModal{{ $product->id }}" tabindex="-1" aria-labelledby="updateStatusModalLabel{{ $product->id }}" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <form method="POST" action="{{ route('admin.offers.updateStatus', $product->id) }}">
                                            @csrf
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="updateStatusModalLabel{{ $product->id }}">تحديث حالة الطلب</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mb-3">
                                                        <label>الحالة</label>
                                                        <select name="status" class="form-control" required>
                                                             <option value="0" {{ $product->status_active_id ==0 ? 'selected' : '' }}>معلق</option>

                                                            <option value="1" {{ $product->is_active == 1 ? 'selected' : '' }}>موافق عليه</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-primary">تحديث</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
</div>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection
