@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')

<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> الطلبات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الطلبات</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            اسم العميل
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            اسم المستلم
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            طريقة الدفع
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            المبلغ الإجمالي
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            الحالة
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            العمليــــات
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($orders as $order)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{$i}}</td>
                                        <td>
                                            {{ $order->user->full_name ?? 'N/A' }}
                                        </td>
                                        <td>
                                            {{ $order->full_name ?? 'N/A' }}
                                        </td>
                                        <td style="font-family: 'Cairo', sans-serif;">{{$order->payment_method}}</td>
                                        <td style="font-family: 'Cairo', sans-serif;">{{$order->items->count();}}</td>
                                        <td style="font-family: 'Cairo', sans-serif;">{{$order->status}}</td>
                                        <td>
                                            <button class="btn btn-success" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{$order->id}}">
                                                <i class="fa fa-edit"></i>
                                            </button>

                                            <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{$order->id}}">
                                                <i class="fa fa-remove"></i>
                                            </button>
                                            <button class="btn btn-success" type="button" data-bs-toggle="modal"
                                                data-bs-target="#details{{$order->id}}">
                                               <a href="{{ route('admin.orders.show', $order->id) }}" class="btn btn-primary">تفاصيل الطلب</a>
                                            </button>
                                        </td>
                                    </tr>


                                    <!-- Edit Order Modal -->
                                    <div class="modal fade" id="edit{{$order->id}}" tabindex="-1"
                                        aria-labelledby="editOrderModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editOrderModalLabel">تعديل الطلب</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form enctype="multipart/form-data" method="post"
                                                        action="{{ route('admin.orders.update', $order->id) }}">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="mb-3">
                                                            <label for="editStatus" class="form-label">الحالة</label>
                                                            <select class="form-control" id="editStatus" name="status"
                                                                required>
                                                                <option value="pending" {{ $order->status == 'pending' ?
                                                                    'selected' : '' }}>معلق</option>
                                                                <option value="shipped" {{ $order->status == 'shipped' ?
                                                                    'selected' : '' }}>تم الشحن</option>
                                                                <option value="delivered" {{ $order->status ==
                                                                    'delivered' ?
                                                                    'selected' : '' }}>تم التوصيل</option>
                                                                <option value="canceled" {{ $order->status == 'canceled'
                                                                    ? 'selected' : '' }}>ملغي</option>
                                                            </select>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">إلغاء</button>
                                                            <button type="submit" class="btn btn-primary">حفظ
                                                                التغييرات</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Order Modal -->
                                    <div class="modal fade" id="delete{{$order->id}}" tabindex="-1"
                                        aria-labelledby="deleteOrderModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteOrderModalLabel">حذف الطلب</h5>
                                                    <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{ route('admin.orders.destroy', $order->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input id="id" type="hidden" name="id" value="{{ $order->id }}">
                                                    <div class="modal-body">هل أنت متأكد من عملية الحذف؟</div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-bs-dismiss="modal">إلغاء</button>
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- DOM / jQuery  Ends-->
        </div>
    </div>

    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
@include('admin.layouts.js')

@endsection