@extends('admin.layouts.master')

@section('title', 'تفاصيل الطلب')

@section('css')
    @include('admin.layouts.css')
@endsection

@section('body')

<div class="page-body">
    <div class="container-fluid mt-4">

        <div class="card" style="background-color:rgb(77, 56, 56); ">
            <div class="card-header">
                <h4>تفاصيل الطلب رقم #{{ $order->id }}</h4>
            </div>
            <div class="card-body">

                <p><strong>اسم العميل:</strong> {{ $order->full_name ?? 'N/A' }}</p>
                <p><strong>طريقة الدفع:</strong> {{ $order->payment_method }}</p>
                <p><strong>العنوان:</strong> {{ $order->shipping_address ?? 'غير متوفر' }}</p>
                <p><strong>الحالة:</strong> {{ $order->status }}</p>
                <p><strong>المبلغ الإجمالي:</strong> {{ number_format($order->total_price, 2) }} ريال</p>
              

                <hr>
                <h5>العناصر:</h5>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>اسم القطعة</th>
                            <th>الكمية</th>
                            <th>سعر الوحدة</th>
                            <th>الخصم</th>
                            <th>الإجمالي</th>
                            <th>مورد القطعة</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($order->items as $item)
                            <tr>
                                <td>{{ $item->sparePart->getTranslation('name', 'ar') ?? '---' }}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>{{ number_format($item->unit_price, 2) }} ريال</td>
                                <td>
                                    @if($item->has_discount)
                                        {{ number_format($item->discount_amount, 2) }} ريال
                                    @else
                                        لا يوجد
                                    @endif
                                </td>
                                <td>
                                    {{ number_format(($item->unit_price * $item->quantity) - $item->discount_amount, 2) }} ريال
                                </td>
                                <td>{{ $item->sparePart->vendor?->getTranslation('name','ar') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    @include('admin.layouts.js')
@endsection