@extends('admin.layouts.master')

@section('title', 'إدارة الباقات')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>الباقات</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">الباقات</li>
                    </ol>
                </div>
                 <div class="col-sm-6 text-end">
                <button class="btn btn-success btn-lg" data-bs-toggle="modal" data-bs-target="#addPackageModal">
                    إضافة باقة جديدة
                </button>                </div>



            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card p-3">
            <div class="table-responsive">
                    <table dir="rtl" class="display datatables" id="dt-plugin-method">
                    <thead>
                        <tr>
                            
                            <th style="min-width: 40px;">#</th>
                             <th style="min-width: 150px;">الاسم</th>
                            <th style="min-width: 120px;">الوصف</th>
                       
                            <th style="min-width: 120px;">الإجراءات</th>


                        </tr>
                    </thead>
                    <tbody>
                        @foreach($packages as $package)
                        <tr>
                            <td>{{ $loop->iteration }}</td>

                            

                            <td>{{ $package->name ?? 'غير متوفر' }}</td>

                            <td>
                                @if($package->description)
                                    {{ Str::limit(strip_tags($package->description), 50) }}
                                @else
                                    <span>غير متوفر</span>
                                @endif
                            </td>

                         
                      

                          

                         


                            <td>
                              <button
                                class="btn btn-success btn-sm"
                                data-bs-toggle="modal"
                                data-bs-target="#editModal{{ $package->id }}"
                                   >
                                <i class="fa fa-edit"></i> تعديل
                            </button>
                                                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $package->id }}">
                                    <i class="fa fa-trash"></i> حذف
                                </button>
                              
                            </td>
                        </tr>

                        <!-- Delete Modal -->
                         <div class="modal fade" id="deleteModal{{ $package->id }}" tabindex="-1"
                                    aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">حذف المنتج</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                هل أنت متأكد أنك تريد حذف هذة الباقة ؟
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إلغاء</button>
                                                <form action="{{ route('admin.packages.delete', $package->id) }}"
                                                    method="post" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                        <!-- Update Status Modal -->
                       <!-- Edit Package Modal -->
                        <div class="modal fade" id="editModal{{ $package->id }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <form action="{{ route('admin.packages.update', $package->id) }}"
                                    method="POST"
                                    class="modal-content">
                                    @csrf
                                    @method('PUT')

                                    <div class="modal-header">
                                        <h5 class="modal-title">تعديل الباقة</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <div class="mb-3">
                                            <label class="form-label">اسم الباقة</label>
                                            <input type="text"
                                                name="name"
                                                class="form-control"
                                                value="{{ $package->name }}"
                                                required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">الوصف</label>
                                            <textarea name="description"
                                                    class="form-control"
                                                    rows="4">{{ $package->description }}</textarea>
                                        </div>

                                       

                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                            إلغاء
                                        </button>
                                        <button type="submit" class="btn btn-success">
                                            تحديث
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>


                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add Package Modal -->
<div class="modal fade" id="addPackageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <form action="{{ route('admin.packages.store') }}" method="POST" class="modal-content">
            @csrf

            <div class="modal-header">
                <h5 class="modal-title">إضافة باقة جديدة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <div class="mb-3">
                    <label class="form-label">اسم الباقة</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">وصف الباقة</label>
                    <textarea name="description" class="form-control" rows="4"></textarea>
                </div>

                {{-- لو عندك سعر --}}



               <div class="mb-3">
                    <label class="mr-sm-2">اسم الماركة</label>
                    <select name="brand_ids[]" id="brand_id" class="form-control" multiple required>
                        @foreach ($brands as $brand)
                            <option value="{{ $brand->id }}">
                                {{ $brand->name['ar']}}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-3">
                    <label class="mr-sm-2">اسم الموديل</label>
                    <select name="model_ids[]" id="model_id" class="form-control" multiple required>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">المنتجات المقترحة مع البافة</label>
                    <select name="product_ids[]" id="product_ids" class="form-control" multiple>
                    </select>
                </div>



                

            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    إلغاء
                </button>
                <button type="submit" class="btn btn-success">
                    حفظ
                </button>
            </div>

        </form>
    </div>
</div>

    
</div>
@endsection

@section('js')
@include('admin.layouts.js')

<script>
    $(document).ready(function() {
    
        

       $('#brand_id').on('change', function () {

            let brandIds = $(this).val(); // ARRAY

            $('#model_id').empty();

            if (brandIds && brandIds.length > 0) {
                $.ajax({
                    url: '/admin/get-models-by-brands',
                    type: 'post',
                    data: {
                        brand_ids: brandIds,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function (models) {
                        models.forEach(function (model) {
                            $('#model_id').append(
                                `<option value="${model.id}">
                                    ${model.name.ar}
                                </option>`
                            );
                        });
                    }
                });
            }
        });

        $('#model_id').on('change', function () {

    let modelIds = $(this).val();
    $('#product_ids').empty();

    if (modelIds && modelIds.length > 0) {
        $.ajax({
            url: '/admin/get-products-by-models',
            type: 'POST',
            data: {
                model_ids: modelIds,
                _token: '{{ csrf_token() }}'
            },
            success: function (products) {
                products.forEach(p => {
                    $('#product_ids').append(
                        `<option value="${p.id}">
                            ${p.name.ar ?? p.name.en}
                        </option>`
                    );
                });
            }
        });
    }
});


    });
</script>
@endsection
