@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')

<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> مدفوعات طلبات  المنتجات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">طلبات  المنتجات</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            اسم العميل
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            اسم المورد
                                        </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            اسم القطعة
                                        </th>
                                       
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            المبلغ الإجمالي
                                        </th>
                                            <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            المبلغ المدفوع
                                        </th>
                                            <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            المبلغ المتبقي
                                        </th>
                                      
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            العمليــــات
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($orderItems as $item)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{$i}}</td>
                                        <td>
                                            {{ $item->order->user->full_name ?? 'N/A' }}
                                        </td>
                                        <td>
                                            {{ $item->sparePart?->vendor?->getTranslation('name','ar') ?? 'N/A' }}
                                        </td>
                                        <td>
                                            {{ $item->sparePart->name?? 'N/A' }}
                                        </td>
                                        <td style="font-family: 'Cairo', sans-serif;">
                                                {{ $item->quantity * $item->unit_price}}
                                        </td>

                                        <td style="font-family: 'Cairo', sans-serif;">
                                            {{ $item->paid_amount ?? '0.00' }}
                                        </td>

                                        <td style="font-family: 'Cairo', sans-serif;">
                                            {{ $item->remaining_amount ?? '0.00' }}
                                        </td>                     
{{--                                         <td style="font-family: 'Cairo', sans-serif;">{{$order->status}}</td>
 --}}                                        <td>
                                            <button class="btn btn-success" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit{{$item->id}}">
                                                <i class="fa fa-edit"></i>
                                            </button>

                                            <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete{{$item->id}}">
                                                <i class="fa fa-remove"></i>
                                            </button>
                                           <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPaymentModal{{$item->id}}">
                                                إضافة دفعة
                                            </button>
                                        </td>
                                    </tr>

                                        <!-- Modal -->
                                        <div class="modal fade" id="addPaymentModal{{$item->id}}" tabindex="-1" aria-labelledby="addPaymentModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <form method="POST" action="{{ route('admin.payments.add_mount_order', $item->id) }}">
                                                    @csrf
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">إضافة دفعة</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="mb-3">
                                                                <label for="amount" class="form-label">المبلغ</label>
                                                                <input type="number" class="form-control" name="amount" required step="0.01" min="0.01">
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-success">حفظ</button>
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    <!-- Delete Order Modal -->
                                   {{--  <div class="modal fade" id="delete{{$order->id}}" tabindex="-1"
                                        aria-labelledby="deleteOrderModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteOrderModalLabel">حذف الطلب</h5>
                                                    <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{ route('admin.orders.destroy', $order->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input id="id" type="hidden" name="id" value="{{ $order->id }}">
                                                    <div class="modal-body">هل أنت متأكد من عملية الحذف؟</div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-bs-dismiss="modal">إلغاء</button>
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div> --}}
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- DOM / jQuery  Ends-->
        </div>
    </div>

    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
@include('admin.layouts.js')

@endsection