@extends('admin.layouts.master')

@section('title')
    إدارة المسؤولين
@endsection

@section('css')
    @include('admin.layouts.css')
@endsection

@section('body')
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> إدارة المسؤولين </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ url('admin/dashboard') }}" style="font-family: 'Cairo', sans-serif;">
                                الرئيسيــــــة /
                            </a>
                        </li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> إدارة المسؤولين </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">

                        {{-- زر إضافة --}}
                        <div class="mb-3">
                            <a href="{{ route('admin.admins.create') }}" class="btn btn-success btn-lg" style="font-family: 'Cairo', sans-serif;">
                                إضافة مسؤول جديد
                            </a>
                        </div>
                     

                        {{-- جدول المسؤولين --}}
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الاسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">البريد الإلكتروني</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصلاحيات</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($admins as $i => $admin)
                                        <tr>
                                            <td>{{ $i + 1 }}</td>
                                            <td>{{ $admin->name }}</td>
                                            <td>{{ $admin->email }}</td>
                                            <td>
                                                @foreach($admin->getAllPermissions() as $permission)
                                                    <span class="badge bg-primary">{{ $permission->name }}</span>
                                                @endforeach
                                            </td>
                                            <td>
                                                {{-- Edit --}}
                                                @can('تعديل المسؤولين')
                                                <a class="btn btn-success btn-sm" href="{{ route('admin.admin_edite', $admin->id) }}">
                                                    <i class="fa fa-edit"></i>
                                                </a>
                                                @endcan

                                                {{-- Delete --}}
                                                @can('حذف المسؤولين')
                                                <form action="{{ route('admin.admin_delete', $admin->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-danger btn-sm" type="submit">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    @include('admin.layouts.js')
@endsection
