@extends('admin.layouts.master')
@section('title')
إضافة مركز خدمة
@endsection

@section('css')
@include('admin.layouts.css')
<style>
    .timetable-row {
        margin-bottom: 15px;
    }

    .form-control {
        font-family: 'Cairo', sans-serif;
    }
</style>
@endsection

@section('body')
<script src="https://code.jquery.com/jquery-3.6.4.min.js" 
        integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" 
        crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية / </a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.service-center.index') }}">مراكز الخدمة</a></li>
                        <li class="breadcrumb-item">إضافة مركز خدمة</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="bookmark"></div>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">إضافـــة مركــز خدمــة</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate enctype="multipart/form-data" method="POST"
                            action="{{ route('admin.service-center.store') }}">
                            @csrf

                            {{-- اسم المركز --}}
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label>اسم مركز الخدمة (عربي)</label>
                                    <input name="name_ar" class="form-control" type="text" value="{{ old('name_ar') }}" required>
                                    @error('name_ar')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label>اسم مركز الخدمة (إنجليزي)</label>
                                    <input name="name_en" class="form-control" type="text" value="{{ old('name_en') }}" required>
                                    @error('name_en')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            {{-- البريد وكلمة المرور --}}
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label>البريد الإلكتروني</label>
                                    <input name="email" class="form-control" type="email" value="{{ old('email') }}" required>
                                    @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label>كلمة المرور</label>
                                    <input name="password" class="form-control" type="password" required>
                                    @error('password')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            {{-- تأكيد كلمة المرور والهاتف --}}
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label>تأكيد كلمة المرور</label>
                                    <input name="password_confirmation" class="form-control" type="password" required>
                                </div>
                                <div class="col-md-6">
                                    <label>رقم الهاتف</label>
                                    <input name="phone" class="form-control" type="text" value="{{ old('phone') }}" required>
                                    @error('phone')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            {{-- المدينة والعنوان --}}
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label>المدينة</label>
                                    <select name="city_id" class="form-control" required>
                                        <option value="" disabled selected>اختر المدينة</option>
                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}" {{ old('city_id') == $city->id ? 'selected' : '' }}>
                                                {{ $city->name['ar'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('city_id')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label>العنوان</label>
                                    <input name="address" class="form-control" type="text" value="{{ old('address') }}" required>
                                    @error('address')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            {{-- الصورة والوصف --}}
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label>الصورة</label>
                                    <input name="image" class="form-control" type="file" accept="image/*">
                                    @error('image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label>الوصف</label>
                                    <textarea name="description" class="form-control">{{ old('description') }}</textarea>
                                    @error('description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            {{-- البراندات --}}
                            <div class="row g-3 mt-3">
                                <div class="form-group mb-2">
                                    <label>اختر براندات السيارات اللتي تعمل بها</label>
                                    <select id="brandSelect" name="brands[]" class="form-control" multiple>
                                        @foreach($brands as $brand)
                                            <option value="{{ $brand->id }}" {{ collect(old('brands'))->contains($brand->id) ? 'selected' : '' }}>
                                                {{ $brand->name['ar'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="text-muted">يمكنك اختيار أكثر من براند بالضغط على Ctrl أو لمس مطول.</small>
                                </div>
                            </div>
                            {{-- الفحوصات --}}
                            @php $oldInspections = old('inspections', []); @endphp
                            <div id="vendor-repair-issues-wrapper" class="row g-3 mt-3">
                                <div class="row g-3 mt-3">
                                    <div id="existingInspections">
                                        @foreach($oldInspections as $inspectionId)
                                            @php
                                               $inspection = App\Models\Inspection::find($inspectionId);
                                                $specialty = $inspection ? $inspection->specialty : null;
                                             @endphp
                                              
                                            @if($inspection)
                                                
                                                <div class="row mb-3 inspection-item align-items-center">
                                                    <input type="hidden" name="inspections[]" value="{{ $inspection->id }}">
                                                    <div class="col-md-4">
                                                        <input type="text" class="form-control" value="{{ $inspection->getTranslation('title','ar')}}" readonly>
                                                    </div>
                                                  
                                                    <div class="col-md-2">
                                                        <button type="button" class="btn btn-danger btn-sm remove-inspection-btn">❌ حذف</button>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>

                                    <hr>
                                    <div id="addInspectionSection" class="mt-4">
                                        <h5>إضافة فحص جديد</h5>

                                        <div class="form-group mb-2">
                                            <label>اختر التخصص</label>
                                            <select id="specialtySelect" class="form-control">
                                                <option value="">-- اختر تخصص --</option>
                                                @foreach($specialties as $specialty)
                                                    <option value="{{ $specialty->id }}">{{ $specialty->getTranslation('title','ar') }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group mb-3">
                                            <label>اختر الفحص</label>
                                            <select id="inspectionSelect" class="form-control" disabled>
                                                <option value="">-- اختر فحص --</option>
                                            </select>
                                        </div>

                                        <button type="button" class="btn btn-success btn-sm" id="addInspectionBtn">➕ إضافة</button>
                                    </div>
                                </div>
                            </div>

                            {{-- الحالة --}}
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label>الحالة</label>
                                    <select name="is_active" class="form-control" required>
                                        <option value="1" {{ old('is_active', 1) == 1 ? 'selected' : '' }}>مفعل</option>
                                        <option value="0" {{ old('is_active') == 0 ? 'selected' : '' }}>غير مفعل</option>
                                    </select>
                                    @error('is_active')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <h5 style="font-family: 'Cairo', sans-serif;">جدول المواعيد</h5>
                                    @foreach ($daysOfWeek as $index => $day)
                                    <div class="timetable-row">
                                        <div class="row g-3">
                                            <div class="col-md-3">
                                                <label style="font-family: 'Cairo', sans-serif;">
                                                    {{ __($day) }}
                                                    <input type="hidden" name="timetables[{{$index}}][day_of_week]"
                                                        value="{{ $day }}">
                                                </label>
                                                <select name="timetables[{{$index}}][is_available]" class="form-control"
                                                    required>
                                                    <option value="0" {{ old("timetables.$index.is_available", 0)==0
                                                        ? 'selected' : '' }}> غير متاح </option>
                                                    <option value="1" {{ old("timetables.$index.is_available")==1
                                                        ? 'selected' : '' }}> متاح</option>
                                                </select>
                                                @error("timetables.$index.is_available")
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col-md-3">
                                                <label style="font-family: 'Cairo', sans-serif;">وقت البدء</label>
                                                <input name="timetables[{{$index}}][start_time]" class="form-control"
                                                    type="time" value="{{ old(" timetables.$index.start_time", '09:00' )
                                                    }}" required>
                                                @error("timetables.$index.start_time")
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col-md-3">
                                                <label style="font-family: 'Cairo', sans-serif;">وقت الانتهاء</label>
                                                <input name="timetables[{{$index}}][end_time]" class="form-control"
                                                    type="time" value="{{ old(" timetables.$index.end_time", '17:00' )
                                                    }}" required>
                                                @error("timetables.$index.end_time")
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary"
                                        style="font-family: 'Cairo', sans-serif;">حفظ البيانات</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')

@endsection