@extends('admin.layouts.master')

@section('title')
مواعيد {{ $vendor->name }}
@endsection

@section('css')
@include('admin.layouts.css')
<style>
    .table th, .table td {
        vertical-align: middle;
        font-family: 'Cairo', sans-serif;
    }
</style>
@endsection

@section('body')
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>مواعيد {{ $vendor->name }}</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}"> الرئيسية  / </a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.service-center.index') }}">  البائعون  </a></li>
                        <li class="breadcrumb-item active">مواعيد {{ $vendor->name }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">جميع المواعيد الخاصة بـ {{ $vendor->name }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover text-center">
                        <thead class="bg-primary text-white">
                            <tr>
                                <th>#</th>
                                <th>اسم المستخدم</th>
                                <th>الفحص</th>
                                <th>التاريخ</th>
                                <th>وقت البدء</th>
                                <th>وقت الانتهاء</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($appointments as $index => $appointment)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ optional($appointment->user)->full_name ?? '-' }}</td>
                                <td>{{ optional($appointment->inspection)->title ?? '-' }}</td>
                                <td>{{ $appointment->date->format('Y-m-d') }}</td>
                                <td>{{ $appointment->start_time->format('H:i') }}</td>
                                <td>{{ $appointment->end_time->format('H:i') }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6">لا توجد مواعيد حالياً</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $appointments->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection
