@extends('admin.layouts.master')
@section('title')
تعديل مركز خدمة
@endsection
@section('css')
@include('admin.layouts.css')
<style>
    .timetable-row {
        margin-bottom: 15px;
    }

    .form-control {
        font-family: 'Cairo', sans-serif;
    }
</style>
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">  /  الرئيسية   </a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.service-center.index') }}">مراكز الخدمة  /  </a>
                        </li>
                        <li class="breadcrumb-item">تعديل مركز خدمة</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="bookmark"></div>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    @if (session('error'))
    <div class="alert alert-danger" role="alert" style="font-family: 'Cairo', sans-serif;">
        {{ session('error') }}
    </div>
    @endif
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">تعديـــل مركــز خدمــة</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate enctype="multipart/form-data" method="POST"
                            action="{{ route('admin.service-center.update', $serviceCenter->id) }}">
                            @csrf
                            @method('PATCH')
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">اسم مركز الخدمة (عربي)</label>
                                    <input name="name_ar" class="form-control" type="text"
                                        value="{{ old('name_ar', optional($serviceCenter)->getTranslation('name', 'ar', true) ?? '') }}"
                                        required>
                                    @error('name_ar')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">اسم مركز الخدمة (إنجليزي)</label>
                                    <input name="name_en" class="form-control" type="text"
                                        value="{{ old('name_en', optional($serviceCenter)->getTranslation('name', 'en', true) ?? '') }}"
                                        required>
                                    @error('name_en')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">البريد الإلكتروني</label>
                                    <input name="email" class="form-control" type="email"
                                        value="{{ old('email', $serviceCenter->email) }}" required>
                                    @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">كلمة المرور (اتركها فارغة لعدم
                                        التغيير)</label>
                                    <input name="password" class="form-control" type="password">
                                    @error('password')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">تأكيد كلمة المرور</label>
                                    <input name="password_confirmation" class="form-control" type="password">
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">رقم الهاتف</label>
                                    <input name="phone" class="form-control" type="text"
                                        value="{{ old('phone', $serviceCenter->phone) }}" required>
                                    @error('phone')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">المدينة</label>
                                    <select name="city_id" class="form-control" required>
                                        <option value="" disabled>اختر المدينة</option>
                                        @foreach ($cities as $city)
                                        <option value="{{ $city->id }}" {{ old('city_id', $serviceCenter->city_id) ==
                                            $city->id ? 'selected' : '' }}>
                                            {{ $city->name['ar'] }}
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('city_id')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">العنوان</label>
                                    <input name="address" class="form-control" type="text"
                                        value="{{ old('address', $serviceCenter->address) }}" required>
                                    @error('address')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                    <input name="image" class="form-control" type="file" accept="image/*">
                                    @if ($serviceCenter->image)
                                    <small>الصورة الحالية: <img src="{{ asset('storage/' . $serviceCenter->image) }}"
                                            width="100" alt="Current Image"></small>
                                    @endif
                                    @error('image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الوصف</label>
                                    <textarea name="description"
                                        class="form-control">{{ old('description', $serviceCenter->description) }}</textarea>
                                    @error('description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            @php
                            $locale = 'ar';
                            @endphp
                            <div class="row g-3 mt-3">
                                   
                                <div id="existingInspections">
                                    <label style="font-family: 'Cairo', sans-serif;">الفحوصات الحالية</label>

                                    @forelse ($serviceCenter->inspections as $inspection)
                                        <div class="row mb-3 inspection-item align-items-center">
                                            {{-- Hidden input to send ID --}}
                                            <input type="hidden" name="inspections[]" value="{{ $inspection->id }}">

                                            {{-- Title --}}
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="{{ $inspection->getTranslation('title', app()->getLocale()) }}" readonly>
                                            </div>

                                            {{-- Specialty --}}
                                            <div class="col-md-3">
                                                <input type="text" class="form-control" value="{{ optional($inspection->speclity)->getTranslation('title', app()->getLocale()) ?? '—' }}" readonly>
                                            </div>

                                            {{-- Remove Button --}}
                                            <div class="col-md-2">
                                                <button type="button" class="btn btn-danger btn-sm remove-inspection-btn">❌ حذف</button>
                                            </div>
                                        </div>
                                    @empty
                                        <p style="color: #888;">لا توجد فحوصات مضافة</p>
                                    @endforelse



                                      
                                </div>
                                 <hr>
                                        <div id="addInspectionSection" class="mt-4">
                                            <h5>إضافة فحص جديد</h5>

                                            {{-- اختيار التخصص --}}
                                            <div class="form-group mb-2">
                                                <label>اختر التخصص</label>
                                                <select id="specialtySelect" class="form-control">
                                                    <option value="">-- اختر تخصص --</option>
                                                    @foreach($specialties as $specialty)
                                                        <option value="{{ $specialty->id }}">{{ $specialty->getTranslation('title', 'ar') }}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            {{-- اختيار الفحص --}}
                                            <div class="form-group mb-3">
                                                <label>اختر الفحص</label>
                                                <select id="inspectionSelect" class="form-control" disabled>
                                                    <option value="">-- اختر فحص --</option>
                                                </select>
                                            </div>

                                            <button type="button" class="btn btn-success btn-sm" id="addInspectionBtn">➕ إضافة</button>
                                        </div>
                               
                            </div>

                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الحالة</label>
                                    <select name="is_active" class="form-control" required>
                                        <option value="1" {{ old('is_active', $serviceCenter->is_active) == 1 ?
                                            'selected' : '' }}>مفعل</option>
                                        <option value="0" {{ old('is_active', $serviceCenter->is_active) == 0 ?
                                            'selected' : '' }}>غير مفعل</option>
                                    </select>
                                    @error('is_active')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <h5 style="font-family: 'Cairo', sans-serif;">جدول المواعيد</h5>
                                    @foreach ($daysOfWeek as $index => $day)
                                    <?php
                                            $timetable = $serviceCenter->timetables->firstWhere('day_of_week', $day);
                                            $startTime = $timetable ? $timetable->start_time : 'غير محدد';
                                            $endTime = $timetable ? $timetable->end_time : 'غير محدد';
                                            $isAvailable = $timetable ? $timetable->is_available : 0;
                                        ?>
                                    <div class="timetable-row">
                                        <div class="row g-3">
                                            <div class="col-md-3">
                                                <label style="font-family: 'Cairo', sans-serif;">
                                                    {{ __($day) }}
                                                    <input type="hidden" name="timetables[{{$index}}][day_of_week]"
                                                        value="{{ $day }}">
                                                </label>
                                                <select name="timetables[{{$index}}][is_available]" class="form-control"
                                                    required>
                                                    <option value="0" {{ old("timetables.$index.is_available",
                                                        $isAvailable)==0 ? 'selected' : '' }}>غير متاح</option>
                                                    <option value="1" {{ old("timetables.$index.is_available",
                                                        $isAvailable)==1 ? 'selected' : '' }}> متاح</option>
                                                </select>
                                                @error("timetables.$index.is_available")
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col-md-3">
                                                <label style="font-family: 'Cairo', sans-serif;">وقت البدء</label>
                                                <input name="timetables[{{$index}}][start_time]" class="form-control"
                                                    type="time" value="{{ old(" timetables.$index.start_time",
                                                    $startTime) }}" required>
                                                @error("timetables.$index.start_time")
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col-md-3">
                                                <label style="font-family: 'Cairo', sans-serif;">وقت الانتهاء</label>
                                                <input name="timetables[{{$index}}][end_time]" class="form-control"
                                                    type="time" value="{{ old(" timetables.$index.end_time", $endTime)
                                                    }}" required>
                                                @error("timetables.$index.end_time")
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary"
                                        style="font-family: 'Cairo', sans-serif;">حفظ التغييرات</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection