@extends('admin.layouts.master')
@section('title')
مراكز الخدمة
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">مراكـــز الخدمـــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item">مراكز الخدمة</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <a href="{{ route('admin.service-center.create') }}" class="btn btn-success btn-lg"
                        style="font-family: 'Cairo', sans-serif;">إضافة مركز خدمة جديد</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الاسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">البريد الإلكتروني</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الهاتف</th>
                                        <th style="font-family: 'Cairo', sans-serif;">المدينة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحجوزات</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($serviceCenters as $serviceCenter)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $serviceCenter->getTranslation('name', 'ar') }}</td>
                                        <td>{{ $serviceCenter->email }}</td>
                                        <td>{{ $serviceCenter->phone }}</td>
                                        <td>{{ $serviceCenter->city ? $serviceCenter->city->name['ar'] : 'غير محدد' }}
                                        </td>
                                      
                                        <td>
                                            <a href="{{route('admin.appointments',$serviceCenter->id)}}" class="badge-success">
                                                
                                                الحجوزات 
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.service-center.edit', $serviceCenter->id) }}"
                                                class="btn btn-success btn-sm"><i class="fa fa-edit"></i></a>
                                            <form
                                                action="{{ route('admin.service-center.destroy', $serviceCenter->id) }}"
                                                method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('هل أنت متأكد من حذف مركز الخدمة؟')">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection