@extends('admin.layouts.master')
@section('title')
تعديل تفاصيل الموقع
@endsection
@section('css')
@include('admin.layouts.css')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.site-details.index') }}">تفاصيل الموقع</a>
                        </li>
                        <li class="breadcrumb-item">تعديل تفاصيل</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="bookmark"></div>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">تعديـــل تفاصيــل الموقــع</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate enctype="multipart/form-data" method="POST"
                            action="{{ route('admin.site-details.update', $siteDetail->id) }}">
                            @csrf
                            @method('PATCH')
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">المفتاح</label>
                                    <input name="key" class="form-control" type="text"
                                        value="{{ old('key', $siteDetail->key) }}" required>
                                    <small class="text-muted">مثال: header_section, terms_condition</small>
                                    @error('key')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">العنوان</label>
                                    <input name="title" class="form-control" type="text"
                                        value="{{ old('title', $siteDetail->title) }}" required>
                                    @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <label style="font-family: 'Cairo', sans-serif;">المحتوى</label>
                                    <textarea name="body" class="form-control summernote"
                                        required>{{ old('body', $siteDetail->body) }}</textarea>
                                    @error('body')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الوصف القصير</label>
                                    <input name="short_description" class="form-control" type="text"
                                        value="{{ old('short_description', $siteDetail->short_description) }}">
                                    @error('short_description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                    <input name="image" class="form-control" type="file" accept="image/*">
                                    @if ($siteDetail->image)
                                    <small>الصورة الحالية: <img src="{{ asset('storage/' . $siteDetail->image->path) }}"
                                            width="100" alt="Current Image"></small>
                                    @endif
                                    @error('image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary"
                                        style="font-family: 'Cairo', sans-serif;">حفظ التغييرات</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script>
    $(document).ready(function() {
            $('.summernote').summernote({
                height: 300,
                lang: 'ar-AR',
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
</script>
@endsection