@extends('admin.layouts.master')

@section('title')
    تفاصيل صفحات الموقع
@endsection

@section('css')
    @include('admin.layouts.css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
@endsection

@section('body')
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">تفاصيل صفحات الموقع</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية / </a></li>
                        <li class="breadcrumb-item">صفحات الموقع</li>
                    </ol>
                </div>
            </div>
        </div>

        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <form action="{{route('admin.site_detail_update')}}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="row">
                @foreach($site_details as $sectionKey => $sectionValue)
                    @if(in_array($sectionKey, ['message', 'setting', 'services']))
                        @continue
                    @endif

                    <div class="col-md-12 mb-5">
                        <div class="card p-3">
                            <h5 class="mb-3">{{ $sectionKey }}</h5>

                            @if(is_array($sectionValue) && isset($sectionValue[0]) && is_array($sectionValue[0]))
                                @foreach($sectionValue as $item)
                                    @if(isset($item['id']) && isset($item['key']))
                                    <div class="border p-3 mb-3">
                                        <input type="hidden" name="sections[{{ $item['id'] }}][key]" value="{{ $item['key'] }}">

                                        <div class="mb-2">
                                            <label>العنوان</label>
                                            <input type="text" class="form-control" name="sections[{{ $item['id'] }}][title]" value="{{ $item['title'] ?? '' }}">
                                        </div>

                                        <div class="mb-2">
                                            <label>وصف قصير</label>
                                            <textarea class="form-control" name="sections[{{ $item['id'] }}][short_description]">{{ $item['short_description'] ?? '' }}</textarea>
                                        </div>

                                        <div class="mb-2">
                                            <label>المحتوى</label>
                                            <textarea class="form-control" name="sections[{{ $item['id'] }}][body]">{{ $item['body'] ?? '' }}</textarea>
                                        </div>

                                        @if(!empty($item['image']))
                                            <div class="mb-2">
                                                <label>صورة حالية:</label><br>
                                                <img src="{{ $item['image'] }}" alt="" style="max-width:150px;">
                                            </div>
                                        @endif

                                        @if(!empty($item['image2']))
                                            <div class="mb-2">
                                                <label>صورة 2:</label><br>
                                                <img src="{{ $item['image2'] }}" alt="" style="max-width:150px;">
                                            </div>
                                        @endif
                                    </div>
                                    @endif
                                @endforeach
                            @elseif(is_array($sectionValue) && isset($sectionValue['id']) && isset($sectionValue['key']))
                                <div class="border p-3 mb-3">
                                    <input type="hidden" name="sections[{{ $sectionValue['id'] }}][key]" value="{{ $sectionValue['key'] }}">

                                    <div class="mb-2">
                                        <label>العنوان</label>
                                        <input type="text" class="form-control" name="sections[{{ $sectionValue['id'] }}][title]" value="{{ $sectionValue['title'] ?? '' }}">
                                    </div>

                                    <div class="mb-2">
                                        <label>وصف قصير</label>
                                        <textarea class="form-control" name="sections[{{ $sectionValue['id'] }}][short_description]">{{ $sectionValue['short_description'] ?? '' }}</textarea>
                                    </div>

                                    <div class="mb-2">
                                        <label>المحتوى</label>
                                        <textarea class="form-control" name="sections[{{ $sectionValue['id'] }}][body]">{{ $sectionValue['body'] ?? '' }}</textarea>
                                    </div>

                                    @if(!empty($sectionValue['image']))
                                        <div class="mb-2">
                                            <label>صورة حالية:</label><br>
                                            <img src="{{ $sectionValue['image'] }}" alt="" style="max-width:150px;">
                                        </div>
                                    @endif

                                    @if(!empty($sectionValue['image2']))
                                        <div class="mb-2">
                                            <label>صورة 2:</label><br>
                                            <img src="{{ $sectionValue['image2'] }}" alt="" style="max-width:150px;">
                                        </div>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>

           
       

        {{-- قسم الخدمات --}}
       <!-- جزء عرض وتعديل الخدمات -->
            <div class="col-md-12 mb-5">
                <div class="card p-3">
                    <h5 class="mb-3">الخدمات</h5>

                    {{-- الخدمات الحالية --}}
                    @if(isset($site_details['services']) && is_array($site_details['services']))
                        @foreach($site_details['services'] as $index => $service)
                            <div class="border p-3 mb-3">
                                <input type="hidden" name="services[{{ $index }}][id]" value="{{ $service['id'] ?? '' }}">

                                <div class="mb-2">
                                    <label>الوصف المختصر</label>
                                    <input type="text" name="services[{{ $index }}][short_text]" class="form-control"
                                        value="{{ $service['short_text'] ?? '' }}">
                                </div>

                                <div class="mb-2">
                                    <label>الصورة</label>
                                    @if(!empty($service['image']))
                                        <div class="mb-2">
                                            <img src="{{ $service['image'] }}" alt="Service Image" style="max-width: 120px;">
                                        </div>
                                    @endif
                                    <input type="file" name="services[{{ $index }}][image]" class="form-control">
                                </div>

                                {{-- حذف الخدمة --}}
                                <div class="mb-2">
                                    <button type="submit" formaction=""
                                            class="btn btn-danger btn-sm"
                                            onclick="return confirm('هل أنت متأكد من حذف هذه الخدمة؟')">
                                        حذف
                                    </button>
                                </div>
                            </div>
                        @endforeach
                    @endif

                    {{-- إضافة خدمة جديدة --}}
                    <div class="border p-3 mt-4">
                        <h6>إضافة خدمة جديدة</h6>
                        <div class="mb-2">
                            <label>الوصف المختصر</label>
                            <input type="text" name="new_service[short_text]" class="form-control">
                        </div>
                        <div class="mb-2">
                            <label>الصورة</label>
                            <input type="file" name="new_service[image]" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
             <div class="text-end">
                <button class="btn btn-primary">حفظ التغييرات</button>
            </div>
      </form>   

    </div>
</div>
@endsection

@section('js')
    @include('admin.layouts.js')
@endsection