@extends('admin.layouts.master')

@section('title')
    مزايا وشروط الموقع
@endsection

@section('css')
    @include('admin.layouts.css')
@endsection

@section('body')

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">صفحات الموقع</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ url('admin/dashboard') }}" style="font-family: 'Cairo', sans-serif;">الرئيسية</a>
                        </li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">صفحات الموقع</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="container-fluid">

        {{-- نعرض حسب النوع --}}
        @foreach($advantages as $type => $items)
            <section class="mb-5">
                <h3 style="font-family: 'Cairo', sans-serif; text-transform: capitalize;">
                    {{ $type === 'term_conditions' ? 'شروط وأحكام' : 'مزايا التطبيق' }}
                </h3>

                <div class="row g-4">
                    @foreach($items as $adv)
                        <div class="col-md-6">
                            <div class="card h-100">
                                <div class="card-body">

                                    {{-- نموذج التحديث --}}
                                    <form action="{{ route('admin.advantage.update',$adv->id) }}" method="POST">
                                        @csrf
                                        @method('PUT')

                                        {{-- العنوان عربي --}}
                                        <div class="mb-3">
                                            <label class="form-label">العنوان (AR)</label>
                                            <input type="text" name="title[ar]"
                                                value="{{ $adv->getTranslation('title','ar') }}"
                                                class="form-control" style="font-family: 'Cairo', sans-serif;">
                                        </div>

                                        {{-- العنوان إنجليزي --}}
                                        <div class="mb-3">
                                            <label class="form-label">Title (EN)</label>
                                            <input type="text" name="title[en]"
                                                value="{{ $adv->getTranslation('title','en') }}"
                                                class="form-control">
                                        </div>

                                        {{-- المحتوى عربي --}}
                                        <div class="mb-3">
                                            <label class="form-label">المحتوى (AR)</label>
                                            <textarea name="content[ar]" id="editor" rows="6"
                                                class="form-control">{{ $adv->getTranslation('content','ar') }}</textarea>
                                        </div>

                                        {{-- المحتوى إنجليزي --}}
                                        <div class="mb-3">
                                            <label class="form-label">Content (EN)</label>
                                            <textarea name="content[en]" id="editor" rows="6"
                                                class="form-control">{{ $adv->getTranslation('content','en') }}</textarea>
                                        </div>

                                        <button type="submit" class="btn btn-primary">تحديث</button>
                                    </form>

                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </section>
        @endforeach

    </div>
</div>

@endsection

@section('js')
   
    <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
    <script>
    ClassicEditor.create(document.querySelector('#editor'))
    .catch(console.error);
    </script>
    @include('admin.layouts.js')
@endsection
