@extends('admin.layouts.master')

@section('title', 'تحديث الحزمة')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')

<div class="page-body">
    <div class="container-fluid">

        <div class="page-header">
            <h3 style="font-family: Cairo">تحديث الحزمة</h3>
        </div>

        <div class="card">
            <div class="card-body">

                <form method="POST" action="{{ route('admin.SubPackages.update', $package->id) }}">
                    @csrf
                    @method('PUT')

                    {{-- اسم الباقة --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>اسم الحزمة</label>
                            <input type="text" name="name" class="form-control" value="{{ $package->name }}" required>
                        </div>

                        <div class="col-md-6">
                            <label>الوصف</label>
                            <textarea name="description" class="form-control">{{ $package->description }}</textarea>
                        </div>

                        <div class="col-md-6">
                            <label>اختر الباقة التابعة للحزمة</label>
                            <select name="parent_id" class="form-control" required>
                                <option value="">اختر</option>
                                @foreach($parentPackages as $cat)
                                    <option value="{{ $cat->id }}" {{ $package->parent_id == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <hr>

                    {{-- زر إضافة Category --}}
                    <button type="button" class="btn btn-success mb-3" id="add-category">
                        + إضافة عناصر
                    </button>

                    {{-- مكان الـ Categories --}}
                    <div id="categories-wrapper">
                        @foreach($categoriesWithItems as $catId => $items)
                        @php
                            $categoryModel = $categories->where('id', $catId)->first();
                        @endphp
                        <div class="card mb-4 category-box">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <strong>تصنيف</strong>
                                <button type="button" class="btn btn-danger btn-sm remove-category">حذف</button>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label>اختر التصنيف</label>
                                    <select name="categories[{{ $loop->index }}][package_category_id]" class="form-control" required>
                                        <option value="">اختر</option>
                                        @foreach($categories as $catOption)
                                            <option value="{{ $catOption->id }}" {{ $catOption->id == $catId ? 'selected' : '' }}>{{ $catOption->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="items-wrapper">
                                    @foreach($items as $itemIndex => $item)
                                    <div class="row border p-2 mb-2 item-row">
                                        <div class="col-md-4">
                                            <label>المنتج / القطعة</label>
                                            <input name="categories[{{ $loop->parent->index }}][items][{{ $itemIndex }}][spare_part_id]" list="parts-{{ $loop->parent->index }}-{{ $itemIndex }}" class="form-control" value="{{ $item->name }}">
                                            <datalist id="parts-{{ $loop->parent->index }}-{{ $itemIndex }}">
                                                @foreach($spareParts as $part)
                                                    <option value="{{ $part->getTranslation('name','ar') }}">
                                                @endforeach
                                            </datalist>
                                        </div>
                                        <div class="col-md-2">
                                            <label>السعر</label>
                                            <input type="number" name="categories[{{ $loop->parent->index }}][items][{{ $itemIndex }}][price]" class="form-control" value="{{ $item->price }}">
                                        </div>
                                        <div class="col-md-2">
                                            <label>رئيسي</label><br>
                                            <input type="checkbox" name="categories[{{ $loop->parent->index }}][items][{{ $itemIndex }}][is_main]" value="1" {{ $item->is_main ? 'checked' : '' }}>
                                        </div>
                                        <div class="col-md-2">
                                            <label>تركيب</label><br>
                                            <input type="checkbox" name="categories[{{ $loop->parent->index }}][items][{{ $itemIndex }}][is_installation]" value="1" {{ $item->is_installation ? 'checked' : '' }}>
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-danger mt-4 remove-item">حذف</button>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>

                                <button type="button" class="btn btn-primary btn-sm add-item">+ إضافة عنصر</button>
                            </div>
                        </div>
                        @endforeach
                    </div>


                    <hr>
                    <button type="submit" class="btn btn-primary">
                        حفظ الحزمة
                    </button>
                </form>

            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
@include('admin.layouts.js')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
let categoryIndex = {{ $package->categories->count() }};

/* =======================
   إضافة Category
======================= */
$('#add-category').on('click', function () {

    let html = `
    <div class="card mb-4 category-box">
        <div class="card-header d-flex justify-content-between align-items-center">
            <strong>تصنيف</strong>
            <button type="button" class="btn btn-danger btn-sm remove-category">حذف</button>
        </div>

        <div class="card-body">

            <div class="mb-3">
                <label>اختر التصنيف</label>
                <select name="categories[${categoryIndex}][package_category_id]" class="form-control" required>
                    <option value="">اختر</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="items-wrapper"></div>

            <button type="button" class="btn btn-primary btn-sm add-item">
                + إضافة عنصر
            </button>

        </div>
    </div>
    `;

    $('#categories-wrapper').append(html);
    categoryIndex++;
});

/* =======================
   إضافة عنصر
======================= */
$(document).on('click', '.add-item', function () {

    let categoryBox = $(this).closest('.category-box');
    let itemsWrapper = categoryBox.find('.items-wrapper');
    let catIndex = $('#categories-wrapper .category-box').index(categoryBox);
    let itemIndex = itemsWrapper.children().length;

    let html = `
    <div class="row border p-2 mb-2 item-row">

       <div class="col-md-4">
            <label>المنتج / القطعة</label>
            <input name="categories[${catIndex}][items][${itemIndex}][spare_part_id]" list="parts-${catIndex}-${itemIndex}" class="form-control" placeholder="اكتب للبحث">
            <datalist id="parts-${catIndex}-${itemIndex}">
                @foreach($spareParts as $part)
                    <option value="{{ $part->getTranslation('name','ar') }}">
                @endforeach
            </datalist>
        </div>


        <div class="col-md-2">
            <label>السعر</label>
            <input type="number" name="categories[${catIndex}][items][${itemIndex}][price]" class="form-control">
        </div>

        <div class="col-md-2">
            <label>رئيسي</label><br>
            <input type="checkbox" name="categories[${catIndex}][items][${itemIndex}][is_main]" value="1">
        </div>

        <div class="col-md-2">
            <label>تركيب</label><br>
            <input type="checkbox" name="categories[${catIndex}][items][${itemIndex}][is_installation]" value="1">
        </div>

        <div class="col-md-2">
            <button type="button" class="btn btn-danger mt-4 remove-item">
                حذف
            </button>
        </div>

    </div>
    `;

    itemsWrapper.append(html);
});

/* =======================
   حذف Category
======================= */
$(document).on('click', '.remove-category', function () {
    $(this).closest('.category-box').remove();
});

/* =======================
   حذف عنصر
======================= */
$(document).on('click', '.remove-item', function () {
    $(this).closest('.item-row').remove();
});</script>
@endsection
