@extends('admin.layouts.master')

@section('title', 'إدارة الباقات')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>حزم الباقات  </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">حزم الباقات </li>
                    </ol>
                </div>
                  <div class="col-sm-6 text-end">
                    <a href="{{ route('admin.SubPackages.create') }}" class="btn btn-success btn-lg">إضافة حزمة جديد</a>
                </div>

{{--<div class="col-sm-6 text-end mb-3">
                    <a href="{{ route('admin.spare_parts.template') }}" class="btn btn-success btn-lg">📥 تحميل ملف المنتجات</a>
                </div>
 --}}
              {{--   <div class="col-sm-6 text-end mb-3">
                    <form action="{{ route('admin.spare_parts.import') }}" method="POST" enctype="multipart/form-data" class="d-inline-block">
                        @csrf
                        <input type="file" name="file" class="form-control d-inline-block w-auto" required>
                        <button type="submit" class="btn btn-primary">📤 رفع ملف Excel</button>
                    </form>
                </div> --}}
               {{--  <form action="{{ route('admin.spare_parts.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="form-group">
                        <label for="import_file">تحميل ملف إكسل</label>
                        <input type="file" name="import_file" class="form-control" required>
                    </div>

                    <button type="submit" class="btn btn-success mt-2">
                        <i class="fa fa-upload"></i> استيراد
                    </button>
                </form>
                 <form action="{{ route('admin.settings.vendor_visibility') }}" method="POST">
                @csrf
                <div class="form-check form-switch">
                    <input class="form-check-input"
                        type="checkbox"
                        id="show_vendor"
                        name="show_vendor"
                        value="1"
                        {{ (\App\Models\Setting::where('key', 'show_vendor')->value('value') ?? 1) ? 'checked' : '' }}>
                    <label class="form-check-label" for="show_vendor">
                        إظهار بيانات البائع في واجهة الـAPI
                    </label>
                </div>

                <button type="submit" class="btn btn-primary mt-3">💾 حفظ</button>
            </form> --}}

            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card p-3">
            <div class="table-responsive">
                    <table dir="rtl" class="display datatables" id="dt-plugin-method">
                    <thead>
                        <tr>
                            
                            <th style="min-width: 40px;">#</th>
                             <th style="min-width: 150px;">الاسم</th>
                            <th style="min-width: 120px;">الوصف</th>
                       
                            <th style="min-width: 120px;">الإجراءات</th>


                        </tr>
                    </thead>
                    <tbody>
                        @foreach($packages as $package)
                        <tr>
                            <td>{{ $loop->iteration }}</td>

                            

                            <td>{{ $package->name ?? 'غير متوفر' }}</td>

                            <td>
                                @if($package->description)
                                    {{ Str::limit(strip_tags($package->description), 50) }}
                                @else
                                    <span>غير متوفر</span>
                                @endif
                            </td>

                         
                      

                          

                         


                            <td>
                            <a href="{{ route('admin.SubPackages.edite', $package->id) }}" class="btn btn-success btn-sm">
                                    <i class="fa fa-edit"></i> تعديل
                                </a>
                               <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $package->id }}">
                                    <i class="fa fa-trash"></i> حذف
                                </button>
                              
                            </td>
                        </tr>

                        <!-- Delete Modal -->
                         <div class="modal fade" id="deleteModal{{ $package->id }}" tabindex="-1"
                                    aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">حذف المنتج</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                هل أنت متأكد أنك تريد حذف هذا الحزمة ؟
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إلغاء</button>
                                                <form action="{{ route('admin.products.destroy', $package->id) }}"
                                                    method="post" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                        <!-- Update Status Modal -->
                       <!-- Edit Package Modal -->
                        <div class="modal fade" id="editModal{{ $package->id }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <form action="{{ route('admin.packages.update', $package->id) }}"
                                    method="POST"
                                    class="modal-content">
                                    @csrf
                                    @method('PUT')

                                    <div class="modal-header">
                                        <h5 class="modal-title">تعديل الباقة</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <div class="mb-3">
                                            <label class="form-label">اسم الباقة</label>
                                            <input type="text"
                                                name="name"
                                                class="form-control"
                                                value="{{ $package->name }}"
                                                required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">الوصف</label>
                                            <textarea name="description"
                                                    class="form-control"
                                                    rows="4">{{ $package->description }}</textarea>
                                        </div>

                                       

                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                            إلغاء
                                        </button>
                                        <button type="submit" class="btn btn-success">
                                            تحديث
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>


                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add Package Modal -->


    
</div>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection
