@extends('admin.layouts.master')
@section('title')
الأقسام الفرعية
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
           toastr.success("{{ session('success') }}");
       @endif
       @if(session('error'))
           toastr.error("{{ session('error') }}");
       @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الأقســـــــام الفرعيـــــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item">الأقسام الفرعية</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <a href="{{ route('admin.subCategories.create') }}" class="btn btn-success btn-lg"
                        style="font-family: 'Cairo', sans-serif;">إضافة قسم فرعي</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اسم القسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">القسم الرئيسي</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصورة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($categories as $category)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{ $i }}</td>
                                        <td>{{ $category->getTranslation('name', 'ar') }}</td>
                                        <td>{{ $category->parent ? $category->parent->getTranslation('name', 'ar') : 'لا
                                            يوجد' }}</td>
                                        <td>
                                            @if ($category->image)
                                            <img width="120" src="{{ asset('storage/' . $category->image) }}"
                                                alt="Category Image">
                                            @else
                                            <span>لا توجد صورة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span
                                                class="badge {{ $category->is_active ? 'badge-success' : 'badge-danger' }}">
                                                {{ $category->is_active ? 'مفعل' : 'غير مفعل' }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.subCategories.edit', $category->id) }}"
                                                class="btn btn-success btn-sm"><i class="fa fa-edit"></i></a>
                                            <form action="{{ route('admin.subCategories.destroy', $category->id) }}"
                                                method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('هل أنت متأكد من حذف القسم؟')">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection