@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

@include('admin.layouts.css')
@endsection
@section('body')
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> الاشتراكات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href=""
                                style="font-family: 'Cairo', sans-serif;">الرئيسيـــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الاشتراكات</li>
                    </ol>
                </div>
                <div class="col-sm-6">

                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الايميل</th>
                                        <th style="font-family: 'Cairo', sans-serif;"> تاريخ الانضمام </th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($subscribes as $subscribe)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{$i}}</td>
                                        <td>{{$subscribe->email}}</td>
                                        <td>{{$subscribe->created_at}}</td>
                                        <td>
                                            <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                                data-original-title="test"
                                                data-bs-target="#exampleModal{{$subscribe->id}}"><i
                                                    class="fa fa-remove"></i>
                                            </button>
                                            <button class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#updateStatus{{$subscribe->id}}"
                                                data-bs-original-title="" title="">
                                                <i class="fas fa-ellipsis-v"></i> ارسال اشعار
                                            </button>
                                        </td>
                                    </tr>
                                    <!-- delete_modal_Grade -->
                                    <div class="modal fade" id="exampleModal{{$subscribe->id}}" tabindex="-1"
                                        role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">حذف الاشتراك
                                                    </h5>
                                                    <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{ route('admin.subscribe.destroy', $subscribe->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <!-- Spoofs DELETE method -->
                                                    <input type="hidden" name="id" value="{{ $subscribe->id }}">
                                                    <div class="modal-body">هل أنت متأكد من الحذف؟</div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-primary" type="button"
                                                            data-bs-dismiss="modal">غلق</button>
                                                        <button class="btn btn-secondary" type="submit">حذف</button>
                                                    </div>
                                                </form>

                                            </div>
                                        </div>
                                    </div>
                                    <!-- Notification Modal -->
                                    <div class="modal fade" id="updateStatus{{$subscribe->id}}" tabindex="-1"
                                        aria-labelledby="updateStatusLabel{{$subscribe->id}}" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="updateStatusLabel{{$subscribe->id}}">
                                                        ارسال اشعار</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{ route('admin.subscribe.notify', $subscribe->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label for="message{{$subscribe->id}}" class="form-label"
                                                                style="font-family: 'Cairo', sans-serif;">الرسالة</label>
                                                            <textarea class="form-control"
                                                                id="message{{$subscribe->id}}" name="message" rows="4"
                                                                required></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-primary">إرسال</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- DOM / jQuery  Ends-->
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>
@endsection
@section('js')
@include('admin.layouts.js')

@endsection