@extends('admin.layouts.master')
@section('title')
تعديل مستخدم
@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif
    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">المستخدمون</a></li>
                        <li class="breadcrumb-item">تعديل مستخدم</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="bookmark"></div>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">تعديـــل مستخــدم</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate enctype="multipart/form-data" method="POST"
                            action="{{ route('admin.users.update', $user->id) }}">
                            @csrf
                            @method('PATCH')
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الاسم الكامل</label>
                                    <input name="full_name" class="form-control" type="text"
                                        value="{{ old('full_name', $user->full_name) }}" required>
                                    @error('full_name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">البريد الإلكتروني</label>
                                    <input name="email" class="form-control" type="email"
                                        value="{{ old('email', $user->email) }}" required>
                                    @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">كلمة المرور (اتركها فارغة لعدم
                                        التغيير)</label>
                                    <input name="password" class="form-control" type="password">
                                    @error('password')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">تأكيد كلمة المرور</label>
                                    <input name="password_confirmation" class="form-control" type="password">
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">رقم الهاتف</label>
                                    <input name="phone" class="form-control" type="text"
                                        value="{{ old('phone', $user->phone) }}" required>
                                    @error('phone')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">المدينة</label>
                                    <select name="city_id" class="form-control" required>
                                        <option value="" disabled>اختر المدينة</option>
                                        @foreach ($cities as $city)
                                        <option value="{{ $city->id }}" {{ old('city_id', $user->city_id) == $city->id ?
                                            'selected' : '' }}>
                                            {{ $city->name['ar'] }}
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('city_id')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                    <input name="image" class="form-control" type="file" accept="image/*">
                                    @if ($user->image)
                                    <small>الصورة الحالية: <img src="{{ asset('storage/' . $user->image) }}" width="100"
                                            alt="Current Image"></small>
                                    @endif
                                    @error('image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label style="font-family: 'Cairo', sans-serif;">البريد مؤكد</label>
                                    <select name="email_verified" class="form-control" required>
                                        <option value="1" {{ old('email_verified', $user->email_verified) == 1 ?
                                            'selected' : '' }}>مؤكد</option>
                                        <option value="0" {{ old('email_verified', $user->email_verified) == 0 ?
                                            'selected' : '' }}>غير مؤكد</option>
                                    </select>
                                    @error('email_verified')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row g-3 mt-3">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary"
                                        style="font-family: 'Cairo', sans-serif;">حفظ التغييرات</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
@include('admin.layouts.js')
@endsection