@extends('admin.layouts.master')

@section('title', 'إضافة طلب ونش')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')

<script>
@if(session('success'))
    toastr.success("{{ session('success') }}");
@endif
@if(session('error'))
    toastr.error("{{ session('error') }}");
@endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>إضافة طلب ونش</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.home') }}">الرئيسية</a>
                        </li>
                        <li class="breadcrumb-item">طلبات الونش</li>
                        <li class="breadcrumb-item active">إضافة طلب ونش</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger m-3">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="card p-4">
            <form method="POST" action="{{ route('admin.winches.store') }}">
                @csrf

                <div class="mb-3">
                    <label>الاسم</label>
                    <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                </div>

                <div class="mb-3">
                    <label>رقم الهاتف</label>
                    <input type="text" name="phone_number" class="form-control" value="{{ old('phone_number') }}" required>
                </div>

                <div class="mb-3">
                    <label>وصف السيارة</label>
                    <textarea name="car_description" class="form-control">{{ old('car_description') }}</textarea>
                </div>

                <div class="mb-3">
                    <label>العنوان الحالي</label>
                    <textarea name="current_address" class="form-control" required>{{ old('current_address') }}</textarea>
                </div>

                <div class="mb-3">
                    <label>عنوان الوجهة</label>
                    <textarea name="destination_address" class="form-control" required>{{ old('destination_address') }}</textarea>
                </div>

                <div class="mb-3">
                    <label>المشكلة</label>
                    <textarea name="issue" class="form-control">{{ old('issue') }}</textarea>
                </div>

                <div class="mb-3">
                    <label>المستخدم</label>
                    <select name="user_id" class="form-control" required>
                        <option value="">-- اختر المستخدم --</option>
                        @foreach($users as $user)
                        <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>
                            {{ $user->full_name }}
                        </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-3">
                    <label>الحالة</label>
                    <select name="status" class="form-control" required>
                        <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                        <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                        <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                    </select>
                </div>

                <div class="text-end">
                    <a href="{{ route('admin.winches.index') }}" class="btn btn-secondary">إلغاء</a>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>

            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
@include('admin.layouts.js')
@endsection
