@extends('admin.layouts.master')

@section('title', 'طلبات الونش')

@section('css')
@include('admin.layouts.css')
@endsection

@section('body')

<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>طلبات الونش</h3>
                </div>
                <div class="col-sm-6 text-end">
                    <a href="{{ route('admin.winches.create') }}" class="btn btn-success">إضافة طلب ونش</a>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card p-3">
                    <div class="table-responsive">
                        <table class="display datatables" id="dt-plugin-method">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>المستخدم</th>
                                    <th>رقم الهاتف</th>
                                    <th>الوصف</th>
                                    <th>من</th>
                                    <th>إلى</th>
                                    <th>الحالة</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($winches as $winch)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $winch->name }}</td>
                                    <td>{{ $winch->user->full_name ?? '-' }}</td>
                                    <td>{{ $winch->phone_number }}</td>
                                    <td>{{ $winch->car_description }}</td>
                                    <td>{{ $winch->current_address }}</td>
                                    <td>{{ $winch->destination_address }}</td>
                                    <td>{{ $winch->status }}</td>
                                    <td>
                                        <!-- Button trigger modal -->
                                        <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#updateStatusModal{{ $winch->id }}">
                                            <i class="fa fa-edit"></i> تحديث الحالة
                                        </button>

                                        <!-- Delete Form -->
                                        <button class="btn btn-danger" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal{{ $winch->id }}">
                                            <i class="fa fa-remove"></i> حذف
                                        </button>
                                    </td>
                                </tr>
                                 <div class="modal fade" id="deleteModal{{ $winch->id }}" tabindex="-1"
                                    aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">حذف الطلب</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                هل أنت متأكد أنك تريد حذف هذا الطلب ؟
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إلغاء</button>
                                                <form action="{{ route('admin.winches.destroy', $winch->id) }}"
                                                    method="post" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Modal -->
                                <div class="modal fade" id="updateStatusModal{{ $winch->id }}" tabindex="-1" aria-labelledby="updateStatusModalLabel{{ $winch->id }}" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <form method="POST" action="{{ route('admin.winches.updateStatus', $winch->id) }}">
                                            @csrf
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="updateStatusModalLabel{{ $winch->id }}">تحديث حالة الطلب</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mb-3">
                                                        <label>الحالة</label>
                                                        <select name="status" class="form-control" required>
                                                            <option value="pending" {{ $winch->status == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                                            <option value="in_progress" {{ $winch->status == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                                            <option value="completed" {{ $winch->status == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                                            <option value="cancelled" {{ $winch->status == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-primary">تحديث</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
@include('admin.layouts.js')
@endsection
