<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $data['subject'] ?? ' New Message' }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f9f9f9;
            padding: 20px;
        }
        .email-container {
            background-color: #fff;
            border-radius: 8px;
            padding: 20px;
            max-width: 600px;
            margin: auto;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        h1 {
            color: #007BFF;
        }
        p {
            margin-bottom: 10px;
        }
        .footer {
            margin-top: 20px;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <h1>{{ $data['subject'] ?? 'New message ' }}</h1>

        @if(!empty($data['content']))
            <p>{{ $data['content'] }}</p>
        @endif

        @if(!empty($data['extra']))
            <p>{{ $data['extra'] }}</p>
        @endif

        <div class="footer">
            هذه رسالة آلية من نظامنا. الرجاء عدم الرد على هذا البريد.
        </div>
    </div>
</body>
</html>
