<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Welcome to {{ config('app.name') }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f8;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0px 4px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #2c3e50;
        }
        .password-box {
            background: #f1f1f1;
            padding: 12px;
            border-radius: 6px;
            font-size: 16px;
            font-weight: bold;
            letter-spacing: 1px;
            margin: 10px 0;
        }
        .btn {
            display: inline-block;
            padding: 12px 20px;
            background: #3490dc;
            color: #fff !important;
            text-decoration: none;
            border-radius: 6px;
            margin-top: 20px;
        }
        .footer {
            margin-top: 25px;
            font-size: 13px;
            color: #777;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Welcome, {{ $name }} 🎉</h1>

    <p>We’re excited to have you join <strong>{{ config('app.name') }}</strong>!</p>

    <p>You can login using:</p>
    <p><strong>Email:</strong> {{ $email }}</p>
    <p><strong>Password:</strong></p>
    <div class="password-box">{{ $password }}</div>

    <p>Please change your password after your first login for better security.</p>

    <a href="{{ config('app.url') }}" class="btn">Go to Website</a>

    <div class="footer">
        <p>Thanks,<br>{{ config('app.name') }} Team</p>
    </div>
</div>
</body>
</html>
