<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\TownController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\MerchantController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\CategoriesController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\SiteDetailController;
use App\Http\Controllers\Admin\StaticPageController;
use Illuminate\Http\Request;

use App\Http\Controllers\Admin\CarCategoryController;
use App\Http\Controllers\Admin\CarModelController;
use App\Http\Controllers\Admin\CarBrandController;
use App\Http\Controllers\Admin\SubscribersController;
use App\Http\Controllers\Admin\ServiceCenterController;
use App\Http\Controllers\Admin\GovernorateController;
use App\Http\Controllers\Admin\OfferController;
use App\Http\Controllers\Admin\CustomePartController;
use App\Http\Controllers\Admin\PaymentsController;
use App\Http\Controllers\Admin\StyleController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\MediaController;

use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\PackageCategoryController;
use App\Http\Controllers\Admin\SubPackagesController;



Route::post('/admin/spare_parts/import', [ProductController::class, 'importSpareParts'])->name('admin.spare_parts.import');
Route::get('/admin/get-filters-by-category/{id}', [CategoriesController::class, 'getFiltersByCategory']);

Route::post('admin/login', [AuthController::class, 'login'])->name('login');

Route::prefix('admin')->name('admin.')->group(function () {
  //  Route::post('/login', [AuthController::class, 'login'])->name('login');
    Route::get('/login', [AuthController::class, 'Formlogin'])->name('login');
    Route::middleware('auth:admin')->group(function () {
        Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
        Route::get('home', [HomeController::class, 'index'])->name('home');
        Route::get('subscribe', [SubscribersController::class, 'index'])->name('subscribe');
        Route::delete('admin/subscribe/{id}', [SubscribersController::class, 'destroy'])->name('subscribe.destroy');
         Route::delete('products/{id}', [ProductController::class, 'destroy'])->name('destroy');

        Route::resource('products', ProductController::class)->names('products');
       
        Route::get('/spare-parts/template', [ProductController::class, 'downloadSparePartsTemplate'])->name('spare_parts.template');

        Route::resource('offers', OfferController::class)->names('offers');
       Route::post('offers/updateStatus/{id}',[ OfferController::class,'updateStatus'])->name('offers.updateStatus');


        Route::resource('categories', CategoriesController::class)->names('categories');
        Route::resource('merchants', MerchantController::class)->names('merchant');
        Route::delete('/merchants/bulk-delete', [MerchantController::class, 'bulkDelete'])->name('merchant.bulk_delete');

      
        Route::resource('service-center', ServiceCenterController::class)->names('service-center');

        Route::resource('users', UserController::class)->names('users');

        Route::resource('notifications', NotificationController::class)->names('notifications');
        Route::post('notifications/{id}/read', [NotificationController::class, 'markAsRead'])
            ->name('notifications.read');
        Route::post('notifications/mark-all-read', [NotificationController::class, 'markAllAsRead'])
            ->name('notifications.markAllAsRead');

        Route::post('advantage', [SiteDetailController::class, 'update'])->name('advantage.update');

        Route::resource('static-pages', StaticPageController::class)->names('site-details');
        Route::resource('carcategory', CarCategoryController::class)->names('carcategory');
        Route::resource('carmodel', CarModelController::class)->names('carmodel');
        Route::resource('carbrand', CarBrandController::class)->names('carbrand');
        Route::delete('/carbrand/bulk-delete', [CarBrandController::class, 'bulkDelete'])->name('carbrand.bulk_delete');

                Route::resource('carstyle', StyleController::class)->names('carstyle');

        Route::put('/admin/advantages/{advantage}', [StaticPageController::class, 'update'])->name('advantages.update');
        Route::post('/subscribe/notify/{id}', [SubscribersController::class, 'notify'])->name('subscribe.notify');
        Route::resource('emirates', TownController::class)->names('emirates');
        Route::resource('governorate', GovernorateController::class)->names('governorate');


        Route::resource('orders', OrderController::class)->names('orders');
        Route::get('settings', [SettingsController::class, 'index'])->name('settings');
        Route::post('settings', [SettingsController::class, 'update'])->name('setting.update');

        Route::put('products/{product}/update-status', [ProductController::class, 'updateStatus'])->name('products.updateStatus');
        Route::resource('silders', SliderController::class)->names('sliders');
        Route::get('admin/vendor-models', [SliderController::class, 'getVendorModels'])->name('vendor.models');

        Route::resource('coupons', \App\Http\Controllers\Admin\CoponController::class)->names('coupons');

       Route::resource('winches', \App\Http\Controllers\Admin\WinchController::class)->names('winches');
       Route::post('winches/{winch}/update-status', [\App\Http\Controllers\Admin\WinchController::class, 'updateStatus'])->name('winches.updateStatus');
       Route::resource('contacts', \App\Http\Controllers\Admin\ContactMessageController::class)->names('contacts');
       Route::post('/get-models-by-brands', [ProductController::class, 'getModelsByBrands'])->name('getModelsByBrand');
       Route::get('vendors/{vendor}/appointments', [ServiceCenterController::class, 'apppintments'])->name('appointments');
      
       Route::resource('spiclizations', \App\Http\Controllers\Admin\SpclizationController::class)->names('spiclizations');
       Route::resource('inceptions', \App\Http\Controllers\Admin\InceptionController::class)->names('inceptions');
       Route::get('/specialties/{id}/inspections', [ServiceCenterController::class, 'getInspections']);


       Route::prefix('custom_parts')->group(function () {
            Route::get('/', [CustomePartController::class, 'index'])->name('custom_parts.index');
            Route::get('/{id}/items', [CustomePartController::class, 'showItems'])->name('custom_parts.items');
            Route::patch('/{id}/update', [CustomePartController::class, 'update'])->name('custom_parts.update');
            Route::post('/offers/{id}/accept', [CustomePartController::class, 'acceptOffer'])->name('custom_parts.accept_offer');
        });

    
        Route::resource('car_market', \App\Http\Controllers\Admin\CarMarketController::class)->names('car_sales');
        Route::resource('site_details', \App\Http\Controllers\Admin\SiteDetailController::class)->names('site_details');
        Route::post('site_details', [\App\Http\Controllers\Admin\SiteDetailController::class, 'update'])->name('site_detail_update');


         Route::prefix('payments.')->name('payments.')->group(function () {
            Route::get('/custome_request', [PaymentsController::class, 'customeRequest'])->name('custom_requests');
            Route::post('/offer-payments/{id}', [PaymentsController::class, 'addMount'])->name('add_mount');
            Route::get('/orders', [PaymentsController::class, 'orderItems'])->name('order_items');
            Route::post('/order-payments/{id}', [PaymentsController::class, 'addMountOrder'])->name('add_mount_order');
           /*  Route::get('/{id}/items', [PaymentsController::class, 'showItems'])->name('custom_parts.items');
            Route::patch('/{id}/update', [PaymentsController::class, 'update'])->name('custom_parts.update');
            Route::post('/offers/{id}/accept', [PaymentsController::class, 'acceptOffer'])->name('custom_parts.accept_offer'); */
        });
        Route::resource('category_filters', \App\Http\Controllers\Admin\CategoryFilterController::class)->names('filters');

       
       Route::prefix('admins')->group(function () {
            Route::get('/', [AdminController::class, 'index'])->name('admins.index');
            Route::put('/{id}', [AdminController::class, 'update'])->name('update_admin.update');
            Route::post('/', [AdminController::class, 'store'])->name('add_admin.store');
            Route::get('/create', [AdminController::class, 'create'])->name('admins.create');
            Route::get('/edite/{id}', [AdminController::class, 'edit'])->name('admin_edite');
            Route::delete('/delete/{id}', [AdminController::class, 'delete'])->name('admin_delete');



        });
       
        Route::prefix('media')->group(function () {
           Route::post('/upload', [MediaController::class, 'upload'])->name('media.upload');
           Route::get('/', [MediaController::class, 'index'])->name('media.index');
        });


        Route::post('/settings/vendor-visibility', [SettingsController::class, 'updateVendorVisibility'])->name('settings.vendor_visibility');

      
         Route::prefix('packages.')->name('packages.')->group(function () {
          
            Route::get('/', [PackageController::class, 'index'])->name('index');
            Route::put('/{id}', [PackageController::class, 'update'])->name('update');
            Route::post('/', [PackageController::class, 'store'])->name('store');
            Route::get('/create', [PackageController::class, 'create'])->name('acreate');
            Route::get('/edite/{id}', [PackageController::class, 'edit'])->name('edite');
            Route::delete('/delete/{package}', [PackageController::class, 'delete'])->name('delete');
        });
          Route::prefix('packageCategories.')->name('packageCategories.')->group(function () {
          
            Route::get('/', [PackageCategoryController::class, 'index'])->name('index');
            Route::put('/{id}', [PackageCategoryController::class, 'update'])->name('update');
            Route::post('/', [PackageCategoryController::class, 'store'])->name('store');
            Route::get('/create', [PackageCategoryController::class, 'create'])->name('acreate');
            Route::get('/edite/{id}', [PackageCategoryController::class, 'edit'])->name('edite');
            Route::delete('/delete/{id}', [PackageCategoryController::class, 'delete'])->name('delete');
        });
          
        Route::prefix('SubPackages.')->name('SubPackages.')->group(function () {
          
            Route::get('/', [SubPackagesController::class, 'index'])->name('index');
            Route::put('/{package}', [SubPackagesController::class, 'update'])->name('update');
            Route::post('/', [SubPackagesController::class, 'store'])->name('store');
            Route::get('/create', [SubPackagesController::class, 'create'])->name('create');
            Route::get('/edite/{id}', [SubPackagesController::class, 'edit'])->name('edite');
            Route::delete('/delete/{id}', [SubPackagesController::class, 'delete'])->name('delete');
        });

        Route::get('/packages/{parent}/sub-packages', [PackageController::class, 'getSubPackages']);
       Route::post('/get-models-by-ids', function (Request $request) {
            return \App\Models\CarModel::whereIn('id', $request->model_ids)
                ->get(['id', 'name']);
        });

        Route::post('/get-products-by-models', [PackageController::class, 'getProductsByModels']);



    });
});