<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MobileApp\AuthController;
use App\Http\Controllers\MobileApp\CartController;
use App\Http\Controllers\Api\Website\FaqController;
use App\Http\Controllers\MobileApp\WinchController;
use App\Http\Controllers\MobileApp\OrderController;
use App\Http\Controllers\Api\Website\HomeController;
use App\Http\Controllers\MobileApp\AboutUsController;
use App\Http\Controllers\MobileApp\UserCarController;
use App\Http\Controllers\MobileApp\FeedbackController;
use App\Http\Controllers\Api\Website\ContactController;
use App\Http\Controllers\MobileApp\ContactUsController;
use App\Http\Controllers\MobileApp\SparePartController;
use App\Http\Controllers\MobileApp\CarForSaleController;
use App\Http\Controllers\MobileApp\CategoriesController;
use App\Http\Controllers\MobileApp\TowRequestController;
use App\Http\Controllers\MobileApp\GovernoratesController;
use App\Http\Controllers\MobileApp\NotificationController;
use App\Http\Controllers\MobileApp\ServiceCenterController;
use App\Http\Controllers\MobileApp\TermsConditionsController;
use App\Http\Controllers\MobileApp\CustomPartRequestController;
use App\Http\Controllers\MobileApp\CategoryProductController;
use App\Http\Controllers\MobileApp\AppointmentController;
use App\Http\Controllers\MobileApp\MetaDataController;
use App\Http\Controllers\MobileApp\CarStyleController;
use App\Http\Controllers\MobileApp\CustomeOfferController;
use App\Http\Controllers\MobileApp\FaceBookAuthController;
use App\Http\Controllers\MobileApp\GoogleAuthController;
use App\Http\Controllers\MobileApp\PackageController;
use App\Http\Controllers\MobileApp\PackageSubscribeController;

use App\Http\Controllers\MobileApp\HomeController as mobileHome;

Route::prefix('mobile')->group(function () {
    // Public Routes
    Route::get('/home', [mobileHome::class, 'index']);
    //   Route::get('/categories-with-brands-and-models', [CategoriesController::class, 'getCategoriesWithBrandsAndModels']);
    Route::get('/governorates-with-cities', [GovernoratesController::class, 'getGovernoratesWithCities']);
    Route::get('/governorates', [GovernoratesController::class, 'index']);
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/verify-otp', [AuthController::class, 'verifyOtp']);
  
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/auth/google', [AuthController::class, 'googelLogin']);
    Route::post('/login/facebook', [FaceBookAuthController::class, 'login']);
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
    Route::post('/reset-password', [AuthController::class, 'resetPassword']);
    Route::get('/spare-parts', [SparePartController::class, 'index']);
    Route::get('/spare-parts/{id}', [SparePartController::class, 'show']);

    Route::get('/categories', [SparePartController::class, 'categories']);
    Route::get('/about-us', [AboutUsController::class, 'index']);
    Route::get('/instllation', [AboutUsController::class, 'instllation']);

    Route::get('/terms-conditions', [TermsConditionsController::class, 'index']);
    Route::get('/contact-us', [ContactUsController::class, 'index']);
   
   
    Route::get('/services-center', [ServiceCenterController::class, 'index']);
    Route::get('/services-center/{id}', [ServiceCenterController::class, 'show']);
    Route::get('/services-center/search/{searchTerm}', [ServiceCenterController::class, 'searchVendors']);

    Route::post('test/send-firebase-notification', [NotificationController::class, 'sendFirebaseTest']);

     Route::get('/category_sparparts/{id}',[CategoryProductController::class,'index']);

    // meta data
    Route::get('/brands', [MetaDataController::class, 'brands']);
    Route::get('/car_categories', [MetaDataController::class, 'carCategories']);
    Route::get('/models/{brand_id}', [MetaDataController::class, 'Fillter_models']);
    Route::get('/engines/{model_id}', [MetaDataController::class, 'fillterEngine']);
    Route::get('/styles', [CarStyleController::class, 'car_style']);

    // delete by phone 
    Route::get('delete/account/{phone}', [AuthController::class, 'deleteByPhone']);


    Route::post('/feedback', [FeedbackController::class, 'store']);
    Route::post('/complain', [FeedbackController::class, 'complain']);

    Route::get('/social', [AuthController::class, 'getSocial']);
    Route::get('/icon-whatsapp', [AuthController::class, 'getIconWhatsapp']);

    Route::prefix('cars-for-sale')->group(function () {
        Route::get('/', [CarForSaleController::class, 'index']);
        Route::middleware('auth:sanctum')->post('/', [CarForSaleController::class, 'store']);
        Route::get('/{id}', [CarForSaleController::class, 'show']);
    });


    Route::get('model/{model}/packages', [PackageController::class, 'getByModel']);

    Route::post('package_subscribe', [PackageController::class, 'store']);


     Route::get('/vendor_days', [PackageSubscribeController::class, 'getVendorsWithAvailableDays']);
     Route::get('/avlaple_slo', [PackageSubscribeController::class, 'getAvailableSlots']);

    
    Route::middleware('auth:sanctum')->group(function () {


        Route::prefix('custom-part-requests')->group(function () {
            Route::post('/', [CustomPartRequestController::class, 'store'])->name('custom-part-requests.store');
            Route::get('/', [CustomPartRequestController::class, 'index'])->name('custom-part-requests.index');
            Route::get('/data', [CustomPartRequestController::class, 'data'])->name('custom-part-requests.data');
            Route::get('/myrequests', [CustomPartRequestController::class, 'myRequests']);
            Route::post('/accept_offer/{id}',[CustomPartRequestController::class,'requestOfferAccept']);
            Route::post('/complete_pay',[CustomPartRequestController::class,'completeRequestPay']);
            Route::post('/cancelled/{id}',[CustomPartRequestController::class,'cancelledCustomeRequest']);

        });

        Route::prefix('winch')->group(function () {
            Route::get('/', [WinchController::class, 'index']);
            Route::post('/', [WinchController::class, 'store']);
            Route::delete('/{id}', [WinchController::class, 'destroy']);

        });

        Route::post('/logout', [AuthController::class, 'logout']);

        Route::prefix('notifications')->group(function () {
            Route::get('/count', [NotificationController::class, 'getUnreadCount'])->name('notifications.count');

        });
       
        Route::post('notifications/mark-all-read', [NotificationController::class, 'markAllAsRead']);
        Route::delete('notifications', [NotificationController::class, 'deleteAll']);
        Route::post('notifications', [NotificationController::class, 'store']);
        Route::delete('notifications/{id}', [NotificationController::class, 'delete']);
        Route::post('notifications/mark-read',[NotificationController::class,'markAllAsRead'])->name('markAsRead');
        Route::prefix('user/')->group(function () {
            Route::post('profile', [AuthController::class, 'updateProfile']);
            Route::get('data', [AuthController::class, 'userData']);
            Route::delete('delete/account', [AuthController::class, 'deleteAccount']);
            Route::post('/change-password', [AuthController::class, 'changePassword']);
        });

        Route::post('/save-device-token', [AuthController::class, 'saveDeviceToken']);
        Route::get('/cart', [CartController::class, 'index']);
        Route::post('/cart/add', [CartController::class, 'add']);
        Route::put('/cart/update/{id}', [CartController::class, 'update']);
        Route::delete('/cart/remove/{id}', [CartController::class, 'remove']);
        Route::get('/notifications', [NotificationController::class, 'index']);
        Route::post('/coupons/verify', [\App\Http\Controllers\MobileApp\CouponController::class, 'verify']);

       
        //Route::get('/category_sparparts/{id}',[CategoryProductController::class,'index']);
        // Route::get('/orders', [OrderController::class, 'index']);
        // Route::post('/orders', [OrderController::class, 'store']);
        // Route::get('/orders/{id}', [OrderController::class, 'show']);
        Route::post('/custom-part-requests', [CustomPartRequestController::class, 'store']);
        Route::get('/custom-part-requests', [CustomPartRequestController::class, 'index']);
        // Route::post('/tow-requests', [TowRequestController::class, 'store']);
        // Route::get('/tow-requests', [TowRequestController::class, 'index']);
        Route::get('/servicecenter_filter', [ServiceCenterController::class, 'filterVendors']);
        


        Route::prefix('user-cars')->group(function () {
            Route::post('/', [UserCarController::class, 'store']);
            Route::post('/custome', [UserCarController::class, 'customeCar']);
            Route::get('/', [UserCarController::class, 'index']);
            Route::get('/data', [UserCarController::class, 'data']);
            Route::put('/{id}', [UserCarController::class, 'update']);
            Route::delete('/{id}', [UserCarController::class, 'destroy']);
        });
       
        Route::post('orders', [OrderController::class, 'store']);

        Route::get('orders', [OrderController::class, 'index']);

        // for booking apointment
        Route::get('/avaliable_times', [AppointmentController::class, 'getAvailableSlots']);
        Route::post('/booking-apointment', [AppointmentController::class, 'reserveAppointment']);
         Route::get('/apointments', [AppointmentController::class, 'userAppointments']);
        Route::delete('/apointments/{id}', [AppointmentController::class, 'delete']);

        Route::get('/center/services/{id}', [AppointmentController::class, 'vendorInceptions']);


        // offer count and mark as read 
            Route::get(
        'packages/{packageId}/children/{model_id}',
        [PackageController::class, 'getPackageChildrenDetails']
    );
          Route::get(
        'package/{packageId}/categories',
        [PackageController::class, 'packageCategory']
    );

        Route::get('/offers_count', [CustomeOfferController::class, 'offers_coumt']);
        Route::post('/offers/mark_read', [CustomeOfferController::class, 'is_read']);    
        Route::post('package_subscribe', [PackageSubscribeController::class, 'store']);
        Route::get('user_subscribes', [PackageSubscribeController::class, 'userSubscribes']);

    });
    Route::get('/data-search-home', [SparePartController::class, 'dataSearch']);

});
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::get('/home', [HomeController::class, 'index']);

Route::post('/contacts', [ContactController::class, 'store']);
Route::get('/faqs', [FaqController::class, 'index']);