<?php
use App\Http\Controllers\Provider\AuthController;

use App\Http\Controllers\Provider\SparePartOrderController;
use App\Http\Controllers\Provider\SparePartController;
use App\Http\Controllers\Provider\ProductController;
use App\Http\Controllers\Provider\OfferController;
use App\Http\Controllers\Provider\WalletController;
use App\Http\Controllers\Provider\ProfileController;
use App\Http\Controllers\Provider\ProviderHomeController;
use App\Http\Controllers\Provider\StaticPagesController;
use App\Http\Controllers\Provider\VendorTimetableController;
use App\Http\Controllers\Provider\VendorInspectionController;
use App\Http\Controllers\Provider\VendorRepairIssueController;
use App\Http\Controllers\Provider\SpecialtyController;
use App\Http\Controllers\Provider\NotificationController;
use App\Http\Controllers\Provider\ContactController;
use App\Http\Controllers\Provider\AppointmentController;
use App\Http\Controllers\Provider\CategoryFilterController;
use App\Http\Controllers\Provider\PackageSubscribeController;


Route::post('provider/register', [AuthController::class, 'registration']);
Route::post('/provider/login', [AuthController::class, 'login']);
Route::get('/cities-categories', [AuthController::class, 'getCategoriesAndCities']);
Route::post('/send-otp', [AuthController::class, 'sendOtp']);
Route::post('/verifyOtp', [AuthController::class, 'verifyOtp']);
Route::post('provider/reset-password',[AuthController::class, 'resetPassword']);
Route::get('meta_data',[ProductController::class, 'metaData']);
Route::get('models/{id}',[CategoryFilterController::class, 'models']);
Route::get('terms', [StaticPagesController::class, 'index']);
Route::Post('help_message', [ContactController::class, 'store']);
Route::get('provider/delete/account/{phone}', [AuthController::class, 'deleteByPhone']);
Route::get('provider/spiclizations',[SpecialtyController::class,'index']);
Route::get('provider/specialtyInceptions',[SpecialtyController::class,'specialtyInceptions']);
Route::get('filters/category/{id}', [CategoryFilterController::class, 'index']);


 //how to make trick to googel
 Route::get('provider/spare_parts', [SparePartController::class, 'index']);
 Route::get('provider/visitor', function () {
        return response()->json([
            'success' => true,
        ]);
    });


Route::middleware('auth:sanctum')->prefix('provider')->group(function () {
    
    Route::get('spare-part-orders', [SparePartOrderController::class, 'vindorOrders']);
    Route::post('spare-part-offers', [SparePartController::class, 'store']); 
    Route::apiResource('products', ProductController::class);
    Route::delete('product-image/{id}', [ProductController::class, 'deleteProductImage']);
    Route::apiResource('offers', OfferController::class);
    Route::delete('product-image/{id}', [OfferController::class, 'deleteProductImage']);
    Route::apiResource('wallets', WalletController::class);
    Route::get('profile', [ProfileController::class, 'show']);
    Route::post('profile', [ProfileController::class, 'update']);
    Route::get('home-data',[ProviderHomeController::class,'index']);
    Route::post('logout', [AuthController::class, 'logout']);
    
    Route::delete('delete-account', [AuthController::class, 'deleteAccount']);
    Route::get('orders_offers',[WalletController::class,'getWalletData']);
    Route::get('offers',[OfferController::class,'index']);
    Route::post('change-password', [ProfileController::class, 'changePassword']);
    Route::get('filter', [ProductController::class, 'filter']);
    
    // time taples 
    Route::post('/timetable', [VendorTimetableController::class, 'store']);
    Route::put('/timetable', [VendorTimetableController::class, 'update']);
    Route::get('/timetable', [VendorTimetableController::class, 'index']);
   
   // inceptions

    Route::post('/inspections', [VendorInspectionController::class, 'store']);
    Route::put('/inspections/{id}', [VendorInspectionController::class, 'update']);
    Route::delete('/inspections/{id}', [VendorInspectionController::class, 'destroy']);
    Route::get('/inspections', [VendorInspectionController::class, 'index']);

    // appointments
    
    Route::get('/appointments',[AppointmentController::class,'index']);
    Route::post('/repair-issues', [VendorRepairIssueController::class, 'store']);
    Route::delete('/repair-issues/{id}', [VendorRepairIssueController::class, 'destroy']);
    Route::get('/repair-issues', [VendorRepairIssueController::class, 'index']);
   
   // Route::resource('notifications', NotificationController::class)->names('notifications');

    Route::prefix('notifications')->name('notifications.')->group(function () {
        Route::get('/', [NotificationController::class, 'index'])->name('index');
        Route::get('/count', [NotificationController::class, 'getUnreadCount'])->name('getUnreadCount');
        Route::delete('/',  [NotificationController::class, 'deleteAll'])->name('deleteAll');
        Route::post('/mark-read',[NotificationController::class,'markAsRead'])->name('markAsRead');
        Route::delete('/{id}', [NotificationController::class, 'delete'])->name('destroy');
    });

    Route::get('/subscribes',[PackageSubscribecontroller::class,'index']);
Route::post('/package-subscribe/add-item-by-barcode', 
    [PackageSubscribeController::class, 'addItemByBarcode']);

    Route::post('/subscribes/{subscribe}/status',[PackageSubscribecontroller::class,'changeStatus']);


    




   


});
