<?php $__env->startSection('title', 'إدارة المنتجات'); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>العــــروض</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">الرئيسية</a></li>
                        <li class="breadcrumb-item active">عروض المنتجات</li>
                    </ol>
                </div>
                <div class="col-sm-6 text-end">
                    <a href="<?php echo e(route('admin.offers.create')); ?>" class="btn btn-success btn-lg">إضافة عرض  جديد</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card p-3">
            <div class="table-responsive">
                    <table dir="rtl" class="display datatables" id="dt-plugin-method">
                    <thead>
                        <tr>
                            
                            <th style="min-width: 40px;">#</th>
                             <th style="min-width: 150px;">الاسم</th>
                            <th style="min-width: 120px;">العنوان</th>
                            <th style="min-width: 100px;">السعر الحالي</th>
                            <th style="min-width: 100px;">السعر القديم</th>
                            <th style="min-width: 80px;">الكمية</th>
                            <th style="min-width: 100px;">القسم</th>
                            <th style="min-width: 120px;">معرض الصور</th>

                          
                            <th style="min-width: 100px;">تاريخ الإضافة</th>
                            <th style="min-width: 120px;">الإجراءات</th>


                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>

                           

                            <td><?php echo e($product->getTranslation('name', 'ar') ?? 'غير متوفر'); ?></td>

                            <td>
                                <?php if($product->description): ?>
                                    <?php echo e(Str::limit(strip_tags($product->description), 50)); ?>

                                <?php else: ?>
                                    <span>غير متوفر</span>
                                <?php endif; ?>
                            </td>

                            <td>
                                <?php if(is_numeric($product->price)): ?>
                                    <?php echo e(number_format((float)$product->price, 2)); ?> ج.م
                                <?php else: ?>
                                    غير متوفر
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($product->discount_percent): ?>
                                    <?php echo e(number_format($product->price * (1 + $product->discount_percent / 100)) . ' ج.م'); ?>

                                <?php else: ?>
                                    <span>لا يوجد خصم</span>
                                <?php endif; ?>
                            </td>

                            <td><?php echo e($product->stock ?? 'غير متوفر'); ?></td>

                            <td><?php echo e(optional($product->category)->getTranslation('name', 'ar') ?? 'غير محدد'); ?></td>

                            <td>
                                <?php if($product->images->isNotEmpty()): ?>
                                    <img src="<?php echo e(asset('storage/' . $product->images->first()->path)); ?>" alt="معرض الصور" width="70">
                                <?php else: ?>
                                    <span>لا يوجد</span>
                                <?php endif; ?>
                            </td>

                         

                            <td><?php echo e($product->created_at ? $product->created_at->format('Y-m-d') : 'غير محدد'); ?></td>

                            <td>
                                <a href="<?php echo e(route('admin.offers.edit', $product->id)); ?>" class="btn btn-success btn-sm">
                                    <i class="fa fa-edit"></i> تعديل
                                </a>
                                <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($product->id); ?>">
                                    <i class="fa fa-trash"></i> حذف
                                </button>
                                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#updateStatusModal<?php echo e($product->id); ?>">
                                    <i class="fa fa-bullhorn"></i> تحديث الحالة
                                </button>
                            </td>
                        </tr>

                        <!-- Delete Modal -->
                        <div class="modal fade" id="deleteModal<?php echo e($product->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog">
                                <form action="<?php echo e(route('admin.products.destroy', $product->id)); ?>" method="POST" class="modal-content">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <div class="modal-header">
                                        <h5 class="modal-title">تأكيد حذف المنتج</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        هل أنت متأكد أنك تريد حذف المنتج "<?php echo e($product->getTranslation('name', 'ar')); ?>"؟
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                        <button type="submit" class="btn btn-danger">حذف</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Update Status Modal -->
                      
                        <div class="modal fade" id="updateStatusModal<?php echo e($product->id); ?>" tabindex="-1" aria-labelledby="updateStatusModalLabel<?php echo e($product->id); ?>" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <form method="POST" action="<?php echo e(route('admin.offers.updateStatus', $product->id)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="updateStatusModalLabel<?php echo e($product->id); ?>">تحديث حالة الطلب</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mb-3">
                                                        <label>الحالة</label>
                                                        <select name="status" class="form-control" required>
                                                             <option value="0" <?php echo e($product->status_active_id ==0 ? 'selected' : ''); ?>>معلق</option>

                                                            <option value="1" <?php echo e($product->is_active == 1 ? 'selected' : ''); ?>>موافق عليه</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-primary">تحديث</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/offer/index.blade.php ENDPATH**/ ?>