

<?php $__env->startSection('title', 'تحديث الحزمة'); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>

<div class="page-body">
    <div class="container-fluid">

        <div class="page-header">
            <h3 style="font-family: Cairo">تحديث الحزمة</h3>
        </div>

        <div class="card">
            <div class="card-body">

                <form method="POST" action="<?php echo e(route('admin.SubPackages.update', $package->id)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>اسم الحزمة</label>
                            <input type="text" name="name" class="form-control" value="<?php echo e($package->name); ?>" required>
                        </div>

                        <div class="col-md-6">
                            <label>الوصف</label>
                            <textarea name="description" class="form-control"><?php echo e($package->description); ?></textarea>
                        </div>

                        <div class="col-md-6">
                            <label>اختر الباقة التابعة للحزمة</label>
                            <select name="parent_id" class="form-control" required>
                                <option value="">اختر</option>
                                <?php $__currentLoopData = $parentPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat->id); ?>" <?php echo e($package->parent_id == $cat->id ? 'selected' : ''); ?>><?php echo e($cat->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <hr>

                    
                    <button type="button" class="btn btn-success mb-3" id="add-category">
                        + إضافة عناصر
                    </button>

                    
                    <div id="categories-wrapper">
                        <?php $__currentLoopData = $categoriesWithItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catId => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $categoryModel = $categories->where('id', $catId)->first();
                        ?>
                        <div class="card mb-4 category-box">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <strong>تصنيف</strong>
                                <button type="button" class="btn btn-danger btn-sm remove-category">حذف</button>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label>اختر التصنيف</label>
                                    <select name="categories[<?php echo e($loop->index); ?>][package_category_id]" class="form-control" required>
                                        <option value="">اختر</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($catOption->id); ?>" <?php echo e($catOption->id == $catId ? 'selected' : ''); ?>><?php echo e($catOption->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="items-wrapper">
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemIndex => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="row border p-2 mb-2 item-row">
                                        <div class="col-md-4">
                                            <label>المنتج / القطعة</label>
                                            <input name="categories[<?php echo e($loop->parent->index); ?>][items][<?php echo e($itemIndex); ?>][spare_part_id]" list="parts-<?php echo e($loop->parent->index); ?>-<?php echo e($itemIndex); ?>" class="form-control" value="<?php echo e($item->name); ?>">
                                            <datalist id="parts-<?php echo e($loop->parent->index); ?>-<?php echo e($itemIndex); ?>">
                                                <?php $__currentLoopData = $spareParts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($part->getTranslation('name','ar')); ?>">
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </datalist>
                                        </div>
                                        <div class="col-md-2">
                                            <label>السعر</label>
                                            <input type="number" name="categories[<?php echo e($loop->parent->index); ?>][items][<?php echo e($itemIndex); ?>][price]" class="form-control" value="<?php echo e($item->price); ?>">
                                        </div>
                                        <div class="col-md-2">
                                            <label>رئيسي</label><br>
                                            <input type="checkbox" name="categories[<?php echo e($loop->parent->index); ?>][items][<?php echo e($itemIndex); ?>][is_main]" value="1" <?php echo e($item->is_main ? 'checked' : ''); ?>>
                                        </div>
                                        <div class="col-md-2">
                                            <label>تركيب</label><br>
                                            <input type="checkbox" name="categories[<?php echo e($loop->parent->index); ?>][items][<?php echo e($itemIndex); ?>][is_installation]" value="1" <?php echo e($item->is_installation ? 'checked' : ''); ?>>
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-danger mt-4 remove-item">حذف</button>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <button type="button" class="btn btn-primary btn-sm add-item">+ إضافة عنصر</button>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>


                    <hr>
                    <button type="submit" class="btn btn-primary">
                        حفظ الحزمة
                    </button>
                </form>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
let categoryIndex = <?php echo e($package->categories->count()); ?>;

/* =======================
   إضافة Category
======================= */
$('#add-category').on('click', function () {

    let html = `
    <div class="card mb-4 category-box">
        <div class="card-header d-flex justify-content-between align-items-center">
            <strong>تصنيف</strong>
            <button type="button" class="btn btn-danger btn-sm remove-category">حذف</button>
        </div>

        <div class="card-body">

            <div class="mb-3">
                <label>اختر التصنيف</label>
                <select name="categories[${categoryIndex}][package_category_id]" class="form-control" required>
                    <option value="">اختر</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="items-wrapper"></div>

            <button type="button" class="btn btn-primary btn-sm add-item">
                + إضافة عنصر
            </button>

        </div>
    </div>
    `;

    $('#categories-wrapper').append(html);
    categoryIndex++;
});

/* =======================
   إضافة عنصر
======================= */
$(document).on('click', '.add-item', function () {

    let categoryBox = $(this).closest('.category-box');
    let itemsWrapper = categoryBox.find('.items-wrapper');
    let catIndex = $('#categories-wrapper .category-box').index(categoryBox);
    let itemIndex = itemsWrapper.children().length;

    let html = `
    <div class="row border p-2 mb-2 item-row">

       <div class="col-md-4">
            <label>المنتج / القطعة</label>
            <input name="categories[${catIndex}][items][${itemIndex}][spare_part_id]" list="parts-${catIndex}-${itemIndex}" class="form-control" placeholder="اكتب للبحث">
            <datalist id="parts-${catIndex}-${itemIndex}">
                <?php $__currentLoopData = $spareParts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($part->getTranslation('name','ar')); ?>">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </datalist>
        </div>


        <div class="col-md-2">
            <label>السعر</label>
            <input type="number" name="categories[${catIndex}][items][${itemIndex}][price]" class="form-control">
        </div>

        <div class="col-md-2">
            <label>رئيسي</label><br>
            <input type="checkbox" name="categories[${catIndex}][items][${itemIndex}][is_main]" value="1">
        </div>

        <div class="col-md-2">
            <label>تركيب</label><br>
            <input type="checkbox" name="categories[${catIndex}][items][${itemIndex}][is_installation]" value="1">
        </div>

        <div class="col-md-2">
            <button type="button" class="btn btn-danger mt-4 remove-item">
                حذف
            </button>
        </div>

    </div>
    `;

    itemsWrapper.append(html);
});

/* =======================
   حذف Category
======================= */
$(document).on('click', '.remove-category', function () {
    $(this).closest('.category-box').remove();
});

/* =======================
   حذف عنصر
======================= */
$(document).on('click', '.remove-item', function () {
    $(this).closest('.item-row').remove();
});</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/sub_backages/edit.blade.php ENDPATH**/ ?>