

<?php $__env->startSection('title'); ?>
إضافة سيارة جديدة
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<script>
    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('admin/dashboard')); ?>">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.car_sales.index')); ?>">السيارات المعروضة</a></li>
                        <li class="breadcrumb-item">إضافة سيارة جديدة</li>
                    </ol>
                </div>
            </div>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5>إضافة سيارة جديدة</h5>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.car_sales.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <label>اسم العميل</label>
                                    <select name="user_id" id="user_id" class="form-control" required style="background-color: red">
                                        <option value="">اختر العميل</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option style="background-color: red" value="<?php echo e($user->id); ?>"><?php echo e($user->full_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>موديل السيارة</label>
                                    <select name="model_id" class="form-control" required>
                                        <option value="">اختر الموديل</option>
                                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($model->id); ?>"><?php echo e($model->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>السعر</label>
                                    <input type="number" name="price" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>الكيلومترات</label>
                                    <input type="number" name="mileage" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>نوع ناقل الحركة</label>
                                    <select name="transmission_type" class="form-control" required>
                                        <option value="">اختر</option>
                                        <option value="1">عادي</option>
                                        <option value="0">أوتوماتيك</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>السنة</label>
                                    <input type="number" name="production_year" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>رقم الهاتف</label>
                                    <input type="text" name="phone_number" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>هل واتساب؟</label>
                                    <select name="is_whatsapp" class="form-control" required>
                                        <option value="0">لا</option>
                                        <option value="1">نعم</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>المدينة</label>
                                    <select name="city_id" class="form-control" required>
                                        <option value="">اختر المدينة</option>
                                        <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($city->id); ?>"><?php echo e($city->name['ar']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>الشكل</label>
                                    <select name="style_id" class="form-control" required>
                                        <option value="">اختر الشكل</option>
                                        <?php $__currentLoopData = $styles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $style): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($style->id); ?>"><?php echo e($style->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>هل يوجد تقسيط؟</label>
                                    <select name="installment_available" class="form-control" required>
                                        <option value="0">لا</option>
                                        <option value="1">نعم</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>هل قابل للتفاوض؟</label>
                                    <select name="negotiability" class="form-control" required>
                                        <option value="0">لا</option>
                                        <option value="1">نعم</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>الصورة</label>
                                    <input type="file" name="image" class="form-control" required>
                                </div>

                                <div class="col-md-12">
                                    <label>الوصف</label>
                                    <textarea name="description" class="form-control" rows="3" required></textarea>
                                </div>

                                <div class="col-md-12">
                                    <label>ملاحظات</label>
                                    <textarea name="notes" class="form-control" rows="2"></textarea>
                                </div>

                                <div class="col-md-12 mt-3">
                                    <label>تفعيل</label>
                                    <select name="is_active" class="form-control">
                                        <option value="1">نعم</option>
                                        <option value="0">لا</option>
                                    </select>
                                </div>

                                <div class="col-md-12 mt-4">
                                    <button type="submit" class="btn btn-primary">حفظ البيانات</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('#user_id').select2({
            placeholder: "اختر العميل",
            allowClear: true
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/car_market/craete.blade.php ENDPATH**/ ?>