

<?php $__env->startSection('title', 'طلبات الونش'); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>

<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>طلبات الونش</h3>
                </div>
                <div class="col-sm-6 text-end">
                    <a href="<?php echo e(route('admin.winches.create')); ?>" class="btn btn-success">إضافة طلب ونش</a>
                </div>
            </div>
        </div>
    </div>

    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card p-3">
                    <div class="table-responsive">
                        <table class="display datatables" id="dt-plugin-method">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>المستخدم</th>
                                    <th>رقم الهاتف</th>
                                    <th>الوصف</th>
                                    <th>من</th>
                                    <th>إلى</th>
                                    <th>الحالة</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $winches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $winch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($winch->name); ?></td>
                                    <td><?php echo e($winch->user->full_name ?? '-'); ?></td>
                                    <td><?php echo e($winch->phone_number); ?></td>
                                    <td><?php echo e($winch->car_description); ?></td>
                                    <td><?php echo e($winch->current_address); ?></td>
                                    <td><?php echo e($winch->destination_address); ?></td>
                                    <td><?php echo e($winch->status); ?></td>
                                    <td>
                                        <!-- Button trigger modal -->
                                        <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#updateStatusModal<?php echo e($winch->id); ?>">
                                            <i class="fa fa-edit"></i> تحديث الحالة
                                        </button>

                                        <!-- Delete Form -->
                                        <button class="btn btn-danger" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal<?php echo e($winch->id); ?>">
                                            <i class="fa fa-remove"></i> حذف
                                        </button>
                                    </td>
                                </tr>
                                 <div class="modal fade" id="deleteModal<?php echo e($winch->id); ?>" tabindex="-1"
                                    aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">حذف الطلب</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                هل أنت متأكد أنك تريد حذف هذا الطلب ؟
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إلغاء</button>
                                                <form action="<?php echo e(route('admin.winches.destroy', $winch->id)); ?>"
                                                    method="post" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Modal -->
                                <div class="modal fade" id="updateStatusModal<?php echo e($winch->id); ?>" tabindex="-1" aria-labelledby="updateStatusModalLabel<?php echo e($winch->id); ?>" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <form method="POST" action="<?php echo e(route('admin.winches.updateStatus', $winch->id)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="updateStatusModalLabel<?php echo e($winch->id); ?>">تحديث حالة الطلب</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mb-3">
                                                        <label>الحالة</label>
                                                        <select name="status" class="form-control" required>
                                                            <option value="pending" <?php echo e($winch->status == 'pending' ? 'selected' : ''); ?>>قيد الانتظار</option>
                                                            <option value="in_progress" <?php echo e($winch->status == 'in_progress' ? 'selected' : ''); ?>>قيد التنفيذ</option>
                                                            <option value="completed" <?php echo e($winch->status == 'completed' ? 'selected' : ''); ?>>مكتمل</option>
                                                            <option value="cancelled" <?php echo e($winch->status == 'cancelled' ? 'selected' : ''); ?>>ملغي</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-primary">تحديث</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/winsh/index.blade.php ENDPATH**/ ?>