<?php $__env->startSection('title'); ?>
الإشعارات
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
<script>
    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>
    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الإشعــارات</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">الرئيسية</a></li>
                        <li class="breadcrumb-item">الإشعارات</li>
                    </ol>
                </div>
                <div class="col-sm-6 text-end">
                    <?php
                    $unreadCount = auth()->user()->notifications()->where('is_read', 0)->count();
                    ?>
                    <?php if($unreadCount > 0): ?>
                    <form action="<?php echo e(route('admin.notifications.markAllAsRead')); ?>" method="POST"
                        style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-primary" style="font-family: 'Cairo', sans-serif;">
                            تحديد الكل كمقروء
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العنوان</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الرسالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">النوع</th>
                                        <th style="font-family: 'Cairo', sans-serif;">مرتبط بـ</th>
                                        <th style="font-family: 'Cairo', sans-serif;">التاريخ</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="<?php echo e($notification->is_read ? '' : 'bg-light'); ?>">
                                        <?php $i++; ?>
                                        <td><?php echo e($i); ?></td>
                                        <td><?php echo e($notification->title); ?></td>
                                        <td><?php echo e(Str::limit($notification->message, 100)); ?></td>
                                        <td><?php echo e($notification->type); ?></td>
                                        <td>
                                            <?php if($notification->related): ?>
                                            <?php
                                            $relatedRoute = '';
                                            if ($notification->related_type === 'App\\Models\\Order') {
                                            $relatedRoute = route('admin.orders.show', $notification->related_id);
                                            } elseif ($notification->related_type === 'App\\Models\\TowRequest') {
                                            $relatedRoute = route('admin.tow-requests.show', $notification->related_id);
                                            }
                                            ?>
                                            <?php if($relatedRoute): ?>
                                            <a href="<?php echo e($relatedRoute); ?>" class="text-primary"
                                                style="font-family: 'Cairo', sans-serif;">
                                                عرض التفاصيل
                                            </a>
                                            <?php else: ?>
                                            <span>غير متوفر</span>
                                            <?php endif; ?>
                                            <?php else: ?>
                                            <span>غير مرتبط</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($notification->created_at->diffForHumans()); ?></td>
                                        <td>
                                            <span
                                                class="badge <?php echo e($notification->is_read ? 'badge-success' : 'badge-danger'); ?>">
                                                <?php echo e($notification->is_read ? 'مقروء' : 'غير مقروء'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <?php if(!$notification->is_read): ?>
                                            <button class="btn btn-sm btn-primary mark-as-read"
                                                data-id="<?php echo e($notification->id); ?>"
                                                style="font-family: 'Cairo', sans-serif;">
                                                <i class="fa fa-check"></i> تحديد كمقروء
                                            </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            <?php echo e($notifications->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    $(document).ready(function() {
            $('#dt-plugin-method').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json'
                },
                pageLength: 10,
                searching: true,
                ordering: true
            });

            $('.mark-as-read').on('click', function() {
                const notificationId = $(this).data('id');
                $.ajax({
                    url: '<?php echo e(url("admin/notifications")); ?>/' + notificationId + '/read',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message);
                            setTimeout(() => location.reload(), 1000);
                        } else {
                            toastr.error(response.message);
                        }
                    },
                    error: function() {
                        toastr.error('حدث خطأ. حاول مرة أخرى.');
                    }
                });
            });
        });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/notifications/index.blade.php ENDPATH**/ ?>