

<?php $__env->startSection('title', 'إدارة الباقات'); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>الباقات</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">الرئيسية</a></li>
                        <li class="breadcrumb-item active">فئات عناصر الباقات</li>
                    </ol>
                </div>
                 <div class="col-sm-6 text-end">
                <button class="btn btn-success btn-lg" data-bs-toggle="modal" data-bs-target="#addPackageModal">
                    إضافة فئة جديدة
                </button>                </div>


              
               

            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="card p-3">
            <div class="table-responsive">
                    <table dir="rtl" class="display datatables" id="dt-plugin-method">
                    <thead>
                        <tr>
                            
                            <th style="min-width: 40px;">#</th>
                             <th style="min-width: 150px;">الاسم</th>
                            <th style="min-width: 120px;">الوصف</th>
                       
                            <th style="min-width: 120px;">الإجراءات</th>


                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>

                            

                            <td><?php echo e($package->name ?? 'غير متوفر'); ?></td>

                            <td>
                                <?php if($package->description): ?>
                                    <?php echo e(Str::limit(strip_tags($package->description), 50)); ?>

                                <?php else: ?>
                                    <span>غير متوفر</span>
                                <?php endif; ?>
                            </td>

                         
                      

                          

                         


                            <td>
                              <button
                                class="btn btn-success btn-sm"
                                data-bs-toggle="modal"
                                data-bs-target="#editModal<?php echo e($package->id); ?>"
                                   >
                                <i class="fa fa-edit"></i> تعديل
                            </button>
                                                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($package->id); ?>">
                                    <i class="fa fa-trash"></i> حذف
                                </button>
                              
                            </td>
                        </tr>

                        <!-- Delete Modal -->
                         <div class="modal fade" id="deleteModal<?php echo e($package->id); ?>" tabindex="-1"
                                    aria-labelledby="deleteModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteModalLabel">حذف المنتج</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                هل أنت متأكد أنك تريد حذف هذة الفئة ؟
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">إلغاء</button>
                                                <form action="<?php echo e(route('admin.packageCategories.delete', $package->id)); ?>"
                                                    method="post" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                        <!-- Update Status Modal -->
                       <!-- Edit Package Modal -->
                        <div class="modal fade" id="editModal<?php echo e($package->id); ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <form action="<?php echo e(route('admin.packageCategories.update', $package->id)); ?>"
                                    method="POST"
                                    class="modal-content">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="modal-header">
                                        <h5 class="modal-title">تعديل الفئة</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <div class="mb-3">
                                            <label class="form-label">اسم الفئة</label>
                                            <input type="text"
                                                name="name"
                                                class="form-control"
                                                value="<?php echo e($package->name); ?>"
                                                required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">الوصف</label>
                                            <textarea name="description"
                                                    class="form-control"
                                                    rows="4"><?php echo e($package->description); ?></textarea>
                                        </div>

                                       

                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                            إلغاء
                                        </button>
                                        <button type="submit" class="btn btn-success">
                                            تحديث
                                        </button>
                                    </div>

                                </form>
                            </div>
                        </div>


                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add Package Modal -->
<div class="modal fade" id="addPackageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <form action="<?php echo e(route('admin.packageCategories.store')); ?>" method="POST" class="modal-content">
            <?php echo csrf_field(); ?>

            <div class="modal-header">
                <h5 class="modal-title">إضافة فئة جديدة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <div class="mb-3">
                    <label class="form-label">اسم الفئة</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">وصف الفئة</label>
                    <textarea name="description" class="form-control" rows="4"></textarea>
                </div>

                





                

            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    إلغاء
                </button>
                <button type="submit" class="btn btn-success">
                    حفظ
                </button>
            </div>

        </form>
    </div>
</div>

    
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/packages-category/index.blade.php ENDPATH**/ ?>