<?php $__env->startSection('title', 'تعديل سلايدر الموديل'); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<script>
    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>
    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <h3 style="font-family: 'Cairo', sans-serif;">تعديل سلايدر الموديل</h3>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/dashboard')); ?>">الرئيسية</a></li>
                <li class="breadcrumb-item active">سلايدر الموديل</li>
            </ol>
        </div>

        <form method="POST"  action="<?php echo e(route('admin.sliders.update', $slider->id)); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="card">
                <div class="card-body">

                    <!-- Arabic Title -->
                    <div class="form-group">
                        <label>العنوان بالعربية</label>
                        <input type="text" name="title[ar]" class="form-control"
                               value="<?php echo e($slider->getTranslation('title','ar')); ?>" required>
                    </div>

                    <!-- English Title -->
                    <div class="form-group">
                        <label>العنوان بالإنجليزية</label>
                        <input type="text" name="title[en]" class="form-control"
                               value="<?php echo e($slider->getTranslation('title','en')); ?>" required>
                    </div>

                    <!-- Model Select -->
                  

                    <!-- Order -->
                    <div class="form-group">
                        <label>الترتيب</label>
                        <input type="number" name="order" class="form-control" value="<?php echo e($slider->order); ?>">
                    </div>

                    <!-- Is Active -->
                    <div class="form-group">
                        <label>الحالة</label>
                        <select name="is_active" class="form-control">
                            <option value="1" <?php echo e($slider->is_active ? 'selected' : ''); ?>>مفعل</option>
                            <option value="0" <?php echo e(!$slider->is_active ? 'selected' : ''); ?>>غير مفعل</option>
                        </select>
                    </div>

                    <!-- Image Upload -->
                    <div class="form-group">
                        <label>الصورة</label>
                        <input type="file" name="image_url" class="form-control">
                        <?php if($slider->image_url): ?>
                            <img src="<?php echo e(asset($slider->image_url)); ?>" width="120" class="mt-2">
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn btn-primary">تحديث</button>

                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/banner/edit.blade.php ENDPATH**/ ?>