

<?php $__env->startSection('title'); ?>
مواعيد <?php echo e($vendor->name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .table th, .table td {
        vertical-align: middle;
        font-family: 'Cairo', sans-serif;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>مواعيد <?php echo e($vendor->name); ?></h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>"> الرئيسية  / </a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.service-center.index')); ?>">  البائعون  </a></li>
                        <li class="breadcrumb-item active">مواعيد <?php echo e($vendor->name); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">جميع المواعيد الخاصة بـ <?php echo e($vendor->name); ?></h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover text-center">
                        <thead class="bg-primary text-white">
                            <tr>
                                <th>#</th>
                                <th>اسم المستخدم</th>
                                <th>الفحص</th>
                                <th>التاريخ</th>
                                <th>وقت البدء</th>
                                <th>وقت الانتهاء</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e(optional($appointment->user)->full_name ?? '-'); ?></td>
                                <td><?php echo e(optional($appointment->inspection)->title ?? '-'); ?></td>
                                <td><?php echo e($appointment->date->format('Y-m-d')); ?></td>
                                <td><?php echo e($appointment->start_time->format('H:i')); ?></td>
                                <td><?php echo e($appointment->end_time->format('H:i')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6">لا توجد مواعيد حالياً</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    <?php echo e($appointments->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/service-center/appointments.blade.php ENDPATH**/ ?>