<?php $__env->startSection('title'); ?>
    مزايا وشروط الموقع
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">صفحات الموقع</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(url('admin/dashboard')); ?>" style="font-family: 'Cairo', sans-serif;">الرئيسية</a>
                        </li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">صفحات الموقع</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="container-fluid">

        
        <?php $__currentLoopData = $advantages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <section class="mb-5">
                <h3 style="font-family: 'Cairo', sans-serif; text-transform: capitalize;">
                    <?php echo e($type === 'term_conditions' ? 'شروط وأحكام' : 'مزايا التطبيق'); ?>

                </h3>

                <div class="row g-4">
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6">
                            <div class="card h-100">
                                <div class="card-body">

                                    
                                    <form action="<?php echo e(route('admin.advantage.update',$adv->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>

                                        
                                        <div class="mb-3">
                                            <label class="form-label">العنوان (AR)</label>
                                            <input type="text" name="title[ar]"
                                                value="<?php echo e($adv->getTranslation('title','ar')); ?>"
                                                class="form-control" style="font-family: 'Cairo', sans-serif;">
                                        </div>

                                        
                                        <div class="mb-3">
                                            <label class="form-label">Title (EN)</label>
                                            <input type="text" name="title[en]"
                                                value="<?php echo e($adv->getTranslation('title','en')); ?>"
                                                class="form-control">
                                        </div>

                                        
                                        <div class="mb-3">
                                            <label class="form-label">المحتوى (AR)</label>
                                            <textarea name="content[ar]" id="editor" rows="6"
                                                class="form-control"><?php echo e($adv->getTranslation('content','ar')); ?></textarea>
                                        </div>

                                        
                                        <div class="mb-3">
                                            <label class="form-label">Content (EN)</label>
                                            <textarea name="content[en]" id="editor" rows="6"
                                                class="form-control"><?php echo e($adv->getTranslation('content','en')); ?></textarea>
                                        </div>

                                        <button type="submit" class="btn btn-primary">تحديث</button>
                                    </form>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </section>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
   
    <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
    <script>
    ClassicEditor.create(document.querySelector('#editor'))
    .catch(console.error);
    </script>
    <?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/site_statistics/index.blade.php ENDPATH**/ ?>