

<?php $__env->startSection('title', 'عناصر الطلب'); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<div class="page-body">
    <div class="container-fluid">
        <h4>عناصر الطلب رقم #<?php echo e($request->id); ?></h4>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                       <table class="table table-bordered table-striped text-center" id="itemsTable">
                            <thead class="table-dark">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th style="width: 25%;">الاسم</th>
                                    <th style="width: 10%;">الكمية</th>
                                    <th style="width: 30%;">ملاحظات</th>
                                    <th style="width: 15%;">العروض</th>
                                </tr>
                            </thead>
  
                            <tbody>
                                <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <td class="text-nowrap"><?php echo e($item->name); ?></td>
                                        <td><?php echo e($item->quantity); ?></td>
                                        <td class="text-wrap"><?php echo e($item->notes ?: '—'); ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-info" data-bs-toggle="modal"
                                                    data-bs-target="#offersModal<?php echo e($item->id); ?>">
                                                عرض العروض
                                            </button>
                                        </td>
                                    </tr>

                                    <!-- Offers Modal -->
                                    <div class="modal fade" id="offersModal<?php echo e($item->id); ?>" tabindex="-1">
                                        <div class="modal-dialog modal-xl">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">العروض للعنصر: <?php echo e($item->name); ?></h5>
                                                </div>
                                                <div class="modal-body">
                                                    <?php $__empty_1 = true; $__currentLoopData = $item->itemOffers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <div class="card mb-3">
                                                            <div class="card-body">
                                                                <p><strong>البائع:</strong> <?php echo e($offer->vendor->name); ?></p>
                                                                <p><strong>السعر:</strong> <?php echo e($offer->price); ?></p>
                                                                <p><strong>الضمان:</strong> <?php echo e($offer->warranty_period); ?></p>
                                                                <p><strong>الحالة:</strong>
                                                                    <?php if($offer->status == 'accepted'): ?>
                                                                        <span class="badge bg-success">تم القبول</span>
                                                                    <?php else: ?>
                                                                        <span class="badge bg-warning">معلق</span>
                                                                    <?php endif; ?>
                                                                </p>

                                                                <?php if($offer->status != 'accepted'): ?>
                                                                    <form method="POST" action="<?php echo e(route('admin.custom_parts.accept_offer', $offer->id)); ?>">
                                                                        <?php echo csrf_field(); ?>
                                                                        <button type="submit" class="btn btn-success">قبول العرض</button>
                                                                    </form>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <p>لا توجد عروض لهذا العنصر.</p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <a href="" class="btn btn-secondary mt-4">رجوع</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/custompart/item.blade.php ENDPATH**/ ?>