

<?php $__env->startSection('title'); ?>
    براندات السيارات
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        <?php if(session('success')): ?>
            toastr.success("<?php echo e(session('success')); ?>");
        <?php endif; ?>
        <?php if(session('error')): ?>
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>
    </script>

    <div class="page-body">
        <div class="container-fluid">
            <div class="page-header">
                <div class="row">
                    <div class="col-sm-6">
                        <h3 style="font-family: 'Cairo', sans-serif;"> براندات السيارات</h3>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(url('admin/dashboard')); ?>" style="font-family: 'Cairo', sans-serif;">
                                    الرئيسيــــــة /
                                </a>
                            </li>
                            <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> براندات السيارات </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-body">

                            
                            <div class="mb-3">
                                <a href="<?php echo e(route('admin.carbrand.create')); ?>" class="btn btn-success btn-lg" style="font-family: 'Cairo', sans-serif;">
                                    أضافـــــــة براند جــديــد
                                </a>
                            </div>

                            
                            <form id="bulkDeleteForm" action="<?php echo e(route('admin.carbrand.bulk_delete')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" id="bulkDeleteBtn" class="btn btn-danger mb-3" disabled>
                                    حذف المحددين
                                </button>
                            </form>

                            
                            <div class="table-responsive">
                                <table class="display datatables" id="dt-plugin-method">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" id="selectAll"></th>
                                            <th>#</th>
                                            <th style="font-family: 'Cairo', sans-serif;">اســــم البراند</th>
                                            <th style="font-family: 'Cairo', sans-serif;"> الصورة الخاصة بالبراند</th>

                                            <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <input type="checkbox" name="ids[]" value="<?php echo e($brand->id); ?>" form="bulkDeleteForm" class="rowCheckbox">
                                                </td>
                                                <td><?php echo e($i + 1); ?></td>
                                                <td><?php echo e($brand->name['ar']); ?></td>
                                                 <td>
                                                    <?php if($brand->image): ?>
                                                    <img width="120" src="<?php echo e(asset('storage/' . $brand->image)); ?>"
                                                        alt="brand Image">
                                                    <?php else: ?>
                                                    <span>لا توجد صورة</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    
                                                    <button class="btn btn-success btn-sm" type="button" data-bs-toggle="modal" data-bs-target="#edit<?php echo e($brand->id); ?>">
                                                        <i class="fa fa-edit"></i>
                                                    </button>

                                                    
                                                    <button class="btn btn-danger btn-sm" type="button" data-bs-toggle="modal" data-bs-target="#delete<?php echo e($brand->id); ?>">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>

                                            
                                            <div class="modal fade" id="edit<?php echo e($brand->id); ?>" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" style="font-family: 'Cairo', sans-serif;">تعديل البراند</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form action="<?php echo e(route('admin.carbrand.update', $brand->id)); ?>" method="POST" enctype="multipart/form-data">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('PATCH'); ?>
                                                                <div class="mb-3">
                                                                    <label>اسم البراند (العربية)</label>
                                                                    <input class="form-control" type="text" name="name_ar" value="<?php echo e(old('name_ar', $brand->name['ar'])); ?>" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label>اسم البراند (الإنجليزية)</label>
                                                                    <input class="form-control" type="text" name="name_en" value="<?php echo e(old('name_en', $brand->name['en'])); ?>" required>
                                                                </div>


                                                                 <div class="mb-3">
                                                                    <label
                                                                        style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                                                    <input class="form-control" type="file" name="image"
                                                                        accept="image">
                                                                    <?php if($brand->image): ?>
                                                                    <small>الصورة الحالية: <img
                                                                            src="<?php echo e(asset('storage/' . $brand->image)); ?>"
                                                                            width="100" alt="Current Image"></small>
                                                                    <?php endif; ?>
                                                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label
                                                                        style="font-family: 'Cairo', sans-serif;">الحالة</label>
                                                                    <select name="is_active" class="form-control" required>
                                                                        <option value="1" <?php echo e(old('is_active', $brand->
                                                                            active) ? 'selected' : ''); ?>>
                                                                            مفعل
                                                                        </option>
                                                                        <option value="0" <?php echo e(old('is_active', $brand->
                                                                            active) ? '' : 'selected'); ?>>
                                                                            غير مفعل
                                                                        </option>
                                                                    </select>
                                                                    <?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إغلاق</button>
                                                                    <button class="btn btn-primary" type="submit">حفظ</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            
                                            <div class="modal fade" id="delete<?php echo e($brand->id); ?>" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد أنك تريد حذف "<?php echo e($brand->name['ar']); ?>" ؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">إلغاء</button>
                                                            <form action="<?php echo e(route('admin.carbrand.destroy', $brand->id)); ?>" method="POST" style="display:inline;">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('DELETE'); ?>
                                                                <button class="btn btn-danger" type="submit">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <script>
        $('#selectAll').on('click', function() {
            $('.rowCheckbox').prop('checked', this.checked);
            toggleBulkDeleteBtn();
        });

        $('.rowCheckbox').on('change', function() {
            toggleBulkDeleteBtn();
        });

        function toggleBulkDeleteBtn() {
            let anyChecked = $('.rowCheckbox:checked').length > 0;
            $('#bulkDeleteBtn').prop('disabled', !anyChecked);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/car_brand/index.blade.php ENDPATH**/ ?>