<?php $__env->startSection('title', 'تعديل منتج'); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        <?php if(session('success')): ?>
            toastr.success("<?php echo e(session('success')); ?>");
        <?php endif; ?>
        <?php if(session('error')): ?>
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>
    </script>

    <div class="page-body">
        <div class="container-fluid">
            <div class="page-header">
                <div class="row">
                    <div class="col-sm-6">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">الرئيسية</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.products.index')); ?>">المنتجات</a></li>
                            <li class="breadcrumb-item active">تعديل منتج</li>
                        </ol>
                    </div>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($error); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-header pb-0"><h5>تعديل منتج</h5></div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('admin.products.update', $product->id)); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>

                                
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label>اسم المنتج (عربي)</label>
                                        <input type="text" name="name_ar" class="form-control" value="<?php echo e(old('name_ar', $product->getTranslation('name', 'ar'))); ?>" required>
                                        <?php $__errorArgs = ['name_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label>اسم المنتج (إنجليزي)</label>
                                        <input type="text" name="name_en" class="form-control" value="<?php echo e(old('name_en', $product->getTranslation('name', 'en'))); ?>" required>
                                        <?php $__errorArgs = ['name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                
                                <div class="row g-3 mt-3">
                                    <div class="col-md-4">
                                        <label>السعر</label>
                                        <input type="number" step="0.01" name="price" class="form-control" value="<?php echo e(old('price', $product->price)); ?>" required>
                                        <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-4">
                                        <label>الكمية</label>
                                        <input type="number" name="stock" class="form-control" value="<?php echo e(old('stock', $product->stock)); ?>" required>
                                        <?php $__errorArgs = ['stock'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-4">
                                        <label>بلد المنشأ</label>
                                        <input name="origin_country" class="form-control" value="<?php echo e(old('origin_country', $product->origin_country)); ?>" required>
                                    </div>
                                </div>

                                
                                <div class="row g-3 mt-3">
                                    <div class="col-md-4">
                                        <label>فترة الضمان</label>
                                        <input name="warranty_period" class="form-control" value="<?php echo e(old('warranty_period', $product->warranty_period)); ?>" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label>القسم</label>
                                        <select name="category_id" class="form-control" required>
                                            <option disabled selected>اختر القسم</option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id', $product->category_id) == $category->id ? 'selected' : ''); ?>>
                                                    <?php echo e($category->getTranslation('name', 'ar')); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                
                                <div class="row g-3 mt-3">
                                    <div class="col-md-6">
                                        <label>الوصف</label>
                                        <textarea name="description"  id="basic-example"  ><?php echo e(old('description', $product->description)); ?></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                     <div class="col-md-3">
                                            <label class="mr-sm-2">اسم الماركة</label>
                                            <select name="brand_ids[]" id="brand_id" class="form-control" multiple required>
                                                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($brand->id); ?>">
                                                        <?php echo e($brand->name['ar']); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                       <div class="col-md-3">
                                            <label class="mr-sm-2">اسم الموديل</label>
                                            <select name="model_ids[]" id="model_id" class="form-control" multiple required>
                                            </select>
                                        </div>
                                </div>
                                

                                
                                <div class="row g-3 mt-3">
                                    <div class="col-md-6">
                                        <label>صور المنتج</label>
                                        <input type="file" name="images[]" class="form-control" accept="image/*" multiple>
                                        <?php $__errorArgs = ['images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label>الحالة</label>
                                        <select name="is_active" class="form-control" required>
                                            <option value="1" <?php echo e(old('is_active', $product->is_active) == 1 ? 'selected' : ''); ?>>مفعل</option>
                                            <option value="0" <?php echo e(old('is_active', $product->is_active) == 0 ? 'selected' : ''); ?>>غير مفعل</option>
                                        </select>
                                        <?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <button class="btn btn-outline-info mb-2" type="button" id="toggleOldImages">عرض صور المنتج القديمة</button>
                                    <div id="oldImagesGallery" class="row d-none">
                                        <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-3 position-relative mb-3">
                                                <img src="<?php echo e(asset('storage/' . $image->path)); ?>"
                                                    class="img-fluid rounded border"
                                                    style="width: 100%; height: 180px; object-fit: cover;"
                                                    alt="صورة المنتج">

                                                <button type="button"
                                                    class="btn btn-sm btn-danger delete-image-btn"
                                                    data-id="<?php echo e($image->id); ?>"
                                                    style="position: absolute; top: 10px; right: 10px;">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>

                                
                                <div class="row g-3 mt-4">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                    </div>
                                </div>
                            </form>
                        </div> <!-- card-body -->
                    </div> <!-- card -->
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
    $(document).ready(function() {
    
          const selectedModelIds = <?php echo json_encode($selectedModelIds ?? [], 15, 512) ?>;

        // 1️⃣ تحميل موديلات المنتج الحالي أول ما الصفحة تفتح
        if (selectedModelIds.length > 0) {
            $.ajax({
                url: '/admin/get-models-by-ids',
                type: 'post',
                data: {
                    model_ids: selectedModelIds,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function (models) {
                    models.forEach(function (model) {
                        $('#model_id').append(
                            `<option value="${model.id}" selected>
                                ${model.name.ar}
                            </option>`
                        );
                    });
                }
            });
        }

       $('#brand_id').on('change', function () {

    let brandIds = $(this).val(); // ARRAY

    $('#model_id').empty();

    if (brandIds && brandIds.length > 0) {
        $.ajax({
            url: '/admin/get-models-by-brands',
            type: 'post',
            data: {
                brand_ids: brandIds,
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function (models) {
                models.forEach(function (model) {
                    $('#model_id').append(
                        `<option value="${model.id}">
                            ${model.name.ar}
                        </option>`
                    );
                });
            }
        });
    }
});

    });
</script>
    <script>
        $(document).ready(function () {
            $('#brand_id').on('change', function () {
                var brandId = $(this).val();
                if (brandId) {
                    $.ajax({
                        url: '/admin/get-models-by-brand/' + brandId,
                        type: 'GET',
                        success: function (data) {
                            $('#model_id').empty().append('<option value="">اختر الموديل</option>');
                            $.each(data, function (key, model) {
                                $('#model_id').append('<option value="' + model.id + '">' + model.name['ar'] + '</option>');
                            });
                        }
                    });
                } else {
                    $('#model_id').empty().append('<option value="">اختر الموديل</option>');
                }
            });
        });

        $('#toggleOldImages').click(function () {
            $('#oldImagesGallery').toggleClass('d-none');
        });
    </script>
    <script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
<script src="https://cdn.tiny.cloud/1/yyqo4m6svtt1k6cubr5ob6b6knb4kdgab982f1j49wvr8p93/tinymce/8/tinymce.min.js" referrerpolicy="origin" crossorigin="anonymous"></script>

<script>
tinymce.init({
  selector: 'textarea#basic-example',
  height: 300,
  plugins: [
    'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
    'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
    'insertdatetime', 'media', 'table', 'help', 'wordcount'
  ],
  toolbar: 'undo redo | blocks | ' +
  'bold italic backcolor | alignleft aligncenter ' +
  'alignright alignjustify | bullist numlist outdent indent | ' +
  'removeformat | help',
  content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }'
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/product/edit.blade.php ENDPATH**/ ?>