<?php $__env->startSection('title'); ?>
مراكز الخدمة
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">مراكـــز الخدمـــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('admin/dashboard')); ?>">الرئيسية</a></li>
                        <li class="breadcrumb-item">مراكز الخدمة</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <a href="<?php echo e(route('admin.service-center.create')); ?>" class="btn btn-success btn-lg"
                        style="font-family: 'Cairo', sans-serif;">إضافة مركز خدمة جديد</a>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الاسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">البريد الإلكتروني</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الهاتف</th>
                                        <th style="font-family: 'Cairo', sans-serif;">المدينة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحجوزات</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    <?php $__currentLoopData = $serviceCenters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serviceCenter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <?php $i++; ?>
                                        <td><?php echo e($i); ?></td>
                                        <td><?php echo e($serviceCenter->getTranslation('name', 'ar')); ?></td>
                                        <td><?php echo e($serviceCenter->email); ?></td>
                                        <td><?php echo e($serviceCenter->phone); ?></td>
                                        <td><?php echo e($serviceCenter->city ? $serviceCenter->city->name['ar'] : 'غير محدد'); ?>

                                        </td>
                                      
                                        <td>
                                            <a href="<?php echo e(route('admin.appointments',$serviceCenter->id)); ?>" class="badge-success">
                                                
                                                الحجوزات 
                                            </a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.service-center.edit', $serviceCenter->id)); ?>"
                                                class="btn btn-success btn-sm"><i class="fa fa-edit"></i></a>
                                            <form
                                                action="<?php echo e(route('admin.service-center.destroy', $serviceCenter->id)); ?>"
                                                method="POST" style="display: inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('هل أنت متأكد من حذف مركز الخدمة؟')">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/service-center/index.blade.php ENDPATH**/ ?>