

<?php $__env->startSection('title'); ?>
    تعديل كوبون
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<script>
    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>
    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">تعديل كوبون</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.home')); ?>" style="font-family: 'Cairo', sans-serif;">الرئيسية</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.coupons.index')); ?>" style="font-family: 'Cairo', sans-serif;">كوبونات الخصم</a>
                        </li>
                        <li class="breadcrumb-item active" style="font-family: 'Cairo', sans-serif;">تعديل كوبون</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger mx-3">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="container-fluid">
        <div class="card p-4">
            <form method="POST" action="<?php echo e(route('admin.coupons.update', $coupon->id)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-3">
                    <label>الكود</label>
                    <input type="text" name="code" class="form-control" value="<?php echo e(old('code', $coupon->code)); ?>" required>
                </div>

                <div class="mb-3">
                    <label>النوع</label>
                    <select name="type" class="form-control" required>
                        <option value="fixed" <?php echo e(old('type', $coupon->type) == 'fixed' ? 'selected' : ''); ?>>مبلغ ثابت</option>
                        <option value="percent" <?php echo e(old('type', $coupon->type) == 'percent' ? 'selected' : ''); ?>>نسبة مئوية</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label>القيمة</label>
                    <input type="number" name="value" class="form-control" step="0.01" value="<?php echo e(old('value', $coupon->value)); ?>" required>
                </div>

                <div class="mb-3">
                    <label>أقصى عدد مرات الاستخدام (اختياري)</label>
                    <input type="number" name="max_usage" class="form-control" value="<?php echo e(old('max_usage', $coupon->max_usage)); ?>">
                </div>

                <div class="mb-3">
                    <label>تاريخ الانتهاء (اختياري)</label>
                    <input type="date" name="expires_at" class="form-control" value="<?php echo e(old('expires_at', $coupon->expires_at ? \Carbon\Carbon::parse($coupon->expires_at)->format('Y-m-d') : '')); ?>">
                </div>

                <div class="mb-3">
                    <label>الحالة</label>
                    <select name="is_active" class="form-control">
                        <option value="1" <?php echo e(old('is_active', $coupon->is_active) == 1 ? 'selected' : ''); ?>>مفعل</option>
                        <option value="0" <?php echo e(old('is_active', $coupon->is_active) == 0 ? 'selected' : ''); ?>>غير مفعل</option>
                    </select>
                </div>

                <div class="text-center">
                    <a href="<?php echo e(route('admin.coupons.index')); ?>" class="btn btn-secondary">إلغاء</a>
                    <button type="submit" class="btn btn-primary">تحديث</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/copon/edite.blade.php ENDPATH**/ ?>