

<?php $__env->startSection('title', 'إضافة طلب ونش'); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>

<script>
<?php if(session('success')): ?>
    toastr.success("<?php echo e(session('success')); ?>");
<?php endif; ?>
<?php if(session('error')): ?>
    toastr.error("<?php echo e(session('error')); ?>");
<?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>إضافة طلب ونش</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.home')); ?>">الرئيسية</a>
                        </li>
                        <li class="breadcrumb-item">طلبات الونش</li>
                        <li class="breadcrumb-item active">إضافة طلب ونش</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <?php if($errors->any()): ?>
    <div class="alert alert-danger m-3">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <div class="container-fluid">
        <div class="card p-4">
            <form method="POST" action="<?php echo e(route('admin.winches.store')); ?>">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label>الاسم</label>
                    <input type="text" name="name" class="form-control" value="<?php echo e(old('name')); ?>" required>
                </div>

                <div class="mb-3">
                    <label>رقم الهاتف</label>
                    <input type="text" name="phone_number" class="form-control" value="<?php echo e(old('phone_number')); ?>" required>
                </div>

                <div class="mb-3">
                    <label>وصف السيارة</label>
                    <textarea name="car_description" class="form-control"><?php echo e(old('car_description')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label>العنوان الحالي</label>
                    <textarea name="current_address" class="form-control" required><?php echo e(old('current_address')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label>عنوان الوجهة</label>
                    <textarea name="destination_address" class="form-control" required><?php echo e(old('destination_address')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label>المشكلة</label>
                    <textarea name="issue" class="form-control"><?php echo e(old('issue')); ?></textarea>
                </div>

                <div class="mb-3">
                    <label>المستخدم</label>
                    <select name="user_id" class="form-control" required>
                        <option value="">-- اختر المستخدم --</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($user->id); ?>" <?php echo e(old('user_id') == $user->id ? 'selected' : ''); ?>>
                            <?php echo e($user->full_name); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label>الحالة</label>
                    <select name="status" class="form-control" required>
                        <option value="pending" <?php echo e(old('status') == 'pending' ? 'selected' : ''); ?>>قيد الانتظار</option>
                        <option value="in_progress" <?php echo e(old('status') == 'in_progress' ? 'selected' : ''); ?>>قيد التنفيذ</option>
                        <option value="completed" <?php echo e(old('status') == 'completed' ? 'selected' : ''); ?>>مكتمل</option>
                        <option value="cancelled" <?php echo e(old('status') == 'cancelled' ? 'selected' : ''); ?>>ملغي</option>
                    </select>
                </div>

                <div class="text-end">
                    <a href="<?php echo e(route('admin.winches.index')); ?>" class="btn btn-secondary">إلغاء</a>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>

            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/winsh/create.blade.php ENDPATH**/ ?>