<?php $__env->startSection('title'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> معلومات عن المحافطات </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('admin/dashboard')); ?>"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;"> أضافـــــــة محافظة
                            جديد
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <a href="#" class="btn btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#addAttributeModal">
                                أضف محافظة جديدة
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables"  id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الاسم</th>
                                        <th>العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td>
                                            <?php echo e($attribute->getTranslation('name','ar')?? 'Default Arabic Name'); ?></td>
                                      
                                        <td>
                                            <!-- Edit Button -->
                                            <a class="btn btn-success" href="#" data-bs-toggle="modal"
                                                data-bs-target="#editAttributeModal<?php echo e($attribute->id); ?>">
                                                <i class="fa fa-edit"></i>
                                            </a>

                                            <!-- Delete Button -->
                                            <button class="btn btn-danger" data-bs-toggle="modal"
                                                data-bs-target="#deleteAttributeModal<?php echo e($attribute->id); ?>">
                                                <i class="fa fa-remove"></i>
                                            </button>
                                        </td>
                                    </tr>

                                    <!-- Edit Attribute Modal -->
                                    <div class="modal fade" id="editAttributeModal<?php echo e($attribute->id); ?>" tabindex="-1"
                                        aria-labelledby="editAttributeModalLabel<?php echo e($attribute->id); ?>"
                                        aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"
                                                        id="editAttributeModalLabel<?php echo e($attribute->id); ?>"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        تعديل المحافطة
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form method="POST"
                                                    action="<?php echo e(route('admin.governorate.update', $attribute->id)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="modal-body">
                                                        <div class="form-group">
                                                            <label style="font-family: 'Cairo', sans-serif;"> الاسم
                                                                بالعربي </label>
                                                            <input type="text" name="name_ar" class="form-control"
                                                                value="<?php echo e($attribute->getTranslation('name','ar')); ?>" required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label style="font-family: 'Cairo', sans-serif;"> الاسم
                                                                بالانجليزي </label>
                                                            <input type="text" name="name_en" class="form-control"
                                                                value="<?php echo e($attribute->getTranslation('name','en')); ?>" required>
                                                        </div>
                                                       
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-primary">حفظ
                                                            التغييرات</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Attribute Modal -->
                                    <div class="modal fade" id="deleteAttributeModal<?php echo e($attribute->id); ?>" tabindex="-1"
                                        aria-labelledby="deleteAttributeModalLabel<?php echo e($attribute->id); ?>"
                                        aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"
                                                        id="deleteAttributeModalLabel<?php echo e($attribute->id); ?>"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        حذف السمة
                                                    </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p style="font-family: 'Cairo', sans-serif;">هل أنت متأكد أنك تريد
                                                        حذف هذه المحافظة؟</p>
                                                </div>
                                                <div class="modal-footer">
                                                    <form action="<?php echo e(route('admin.governorate.destroy', $attribute->id)); ?>"
                                                        method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">إغلاق</button>
                                                        <button type="submit" class="btn btn-danger">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Add Attribute Modal -->
    <div class="modal fade" id="addAttributeModal" tabindex="-1" aria-labelledby="addAttributeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('admin.governorate.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="addAttributeModalLabel">إضافة مدينة جديدة</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label style="font-family: 'Cairo', sans-serif;">الاسم بالعربي</label>
                            <input type="text" name="name_ar" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label style="font-family: 'Cairo', sans-serif;">الاسم بالإنجليزي</label>
                            <input type="text" name="name_en" class="form-control" required>
                        </div>
                        
                    </div>
                  
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                        <button type="submit" class="btn btn-primary">حفظ</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/governate/index.blade.php ENDPATH**/ ?>