<?php $__env->startSection('title'); ?>
الأقسام الرئيسية
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
<script
  src="https://code.jquery.com/jquery-3.6.4.min.js"
  integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8="
  crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script>

    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الأقســـــــام الرئيسيـــــة</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('admin/dashboard')); ?>"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الأقســام الرئيسيـــــــة
                        </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <a href="<?php echo e(route('admin.categories.create')); ?>" class="btn btn-success btn-lg"
                                style="font-family: 'Cairo', sans-serif;">
                                أضافـــــــة قســم جــديــد
                            </a>
                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="font-family: 'Cairo', sans-serif;">اســــم القســم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الصـــورة الخاصة بالقسم</th>
                                        <th style="font-family: 'Cairo', sans-serif;">الحالة</th>
                                        <th style="font-family: 'Cairo', sans-serif;">العمليـــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <?php $i++; ?>
                                        <td><?php echo e($i); ?></td>
                                        <td><?php echo e($category->getTranslation('name', 'ar')); ?></td>
                                        <td>
                                            <?php if($category->image): ?>
                                            <img width="120" src="<?php echo e(asset('storage/' . $category->image)); ?>"
                                                alt="Category Image">
                                            <?php else: ?>
                                            <span>لا توجد صورة</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span
                                                class="badge <?php echo e($category->is_active ? 'badge-success' : 'badge-danger'); ?>">
                                                <?php echo e($category->is_active ? 'مفعل' : 'غير مفعل'); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-success btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#edit<?php echo e($category->id); ?>"><i
                                                    class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger btn-sm" type="button" data-bs-toggle="modal"
                                                data-bs-target="#delete<?php echo e($category->id); ?>"><i
                                                    class="fa fa-trash"></i></button>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade modal-xl" id="edit<?php echo e($category->id); ?>" tabindex="-1" role="dialog"
                                        aria-labelledby="editCategoryLabel<?php echo e($category->id); ?>" aria-hidden="true">
                                        <div class="modal-dialog modal-xl" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editCategoryLabel<?php echo e($category->id); ?>"
                                                        style="font-family: 'Cairo', sans-serif;">تعديل القســم</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('admin.categories.update', $category->id)); ?>"
                                                        method="post" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PATCH'); ?>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                (العربية)</label>
                                                            <input class="form-control" type="text" name="name_ar"
                                                                value="<?php echo e(old('name_ar', $category->getTranslation('name', 'ar'))); ?>"
                                                                required>
                                                            <?php $__errorArgs = ['name_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="text-danger"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">اسم القسم
                                                                (الإنجليزية)</label>
                                                            <input class="form-control" type="text" name="name_en"
                                                                value="<?php echo e(old('name_en', $category->getTranslation('name', 'en'))); ?>"
                                                                required>
                                                            <?php $__errorArgs = ['name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="text-danger"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label
                                                                style="font-family: 'Cairo', sans-serif;">الصورة</label>
                                                            <input class="form-control" type="file" name="image"
                                                                accept="image/*">
                                                            <?php if($category->image): ?>
                                                            <small>الصورة الحالية: <img
                                                                    src="<?php echo e(asset('storage/' . $category->image)); ?>"
                                                                    width="100" alt="Current Image"></small>
                                                            <?php endif; ?>
                                                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="text-danger"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label style="font-family: 'Cairo', sans-serif;">القسم
                                                                الرئيسي</label>
                                                            <select name="parent_id" class="form-control">
                                                                <option value="">لا يوجد قسم رئيسي</option>
                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($parent->id !== $category->id): ?>
                                                                <option value="<?php echo e($parent->id); ?>" <?php echo e(old('parent_id',
                                                                    $category->parent_id) == $parent->id ? 'selected' :
                                                                    ''); ?>>
                                                                    <?php echo e($parent->getTranslation('name', 'ar')); ?>

                                                                </option>
                                                                <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="text-danger"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label
                                                                style="font-family: 'Cairo', sans-serif;">الحالة</label>
                                                            <select name="is_active" class="form-control" required>
                                                                <option value="1" <?php echo e(old('is_active', $category->
                                                                    is_active) ? 'selected' : ''); ?>>
                                                                    مفعل
                                                                </option>
                                                                <option value="0" <?php echo e(old('is_active', $category->
                                                                    is_active) ? '' : 'selected'); ?>>
                                                                    غير مفعل
                                                                </option>
                                                            </select>
                                                            <?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="text-danger"><?php echo e($message); ?></span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-secondary" type="button"
                                                                data-bs-dismiss="modal">إغلاق</button>
                                                            <button class="btn btn-primary" type="submit">حفظ</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete<?php echo e($category->id); ?>" tabindex="-1" role="dialog"
                                        aria-labelledby="deleteCategoryLabel<?php echo e($category->id); ?>" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteCategoryLabel<?php echo e($category->id); ?>"
                                                        style="font-family: 'Cairo', sans-serif;">تأكيد الحذف</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    هل أنت متأكد أنك تريد حذف قسم "<?php echo e($category->getTranslation('name',
                                                    'ar')); ?>"؟ هذا الإجراء لا يمكن التراجع عنه.
                                                </div>
                                                <div class="modal-footer">
                                                    <button class="btn btn-secondary" type="button"
                                                        data-bs-dismiss="modal">إلغاء</button>
                                                    <form
                                                        action="<?php echo e(route('admin.categories.destroy', $category->id)); ?>"
                                                        method="POST" style="display: inline;">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button class="btn btn-danger" type="submit">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/category/index.blade.php ENDPATH**/ ?>