

<?php $__env->startSection('title', 'تفاصيل الطلب'); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>

<div class="page-body">
    <div class="container-fluid mt-4">

        <div class="card" style="background-color:rgb(77, 56, 56); ">
            <div class="card-header">
                <h4>تفاصيل الطلب رقم #<?php echo e($order->id); ?></h4>
            </div>
            <div class="card-body">

                <p><strong>اسم العميل:</strong> <?php echo e($order->full_name ?? 'N/A'); ?></p>
                <p><strong>طريقة الدفع:</strong> <?php echo e($order->payment_method); ?></p>
                <p><strong>العنوان:</strong> <?php echo e($order->shipping_address ?? 'غير متوفر'); ?></p>
                <p><strong>الحالة:</strong> <?php echo e($order->status); ?></p>
                <p><strong>المبلغ الإجمالي:</strong> <?php echo e(number_format($order->total_price, 2)); ?> ريال</p>
              

                <hr>
                <h5>العناصر:</h5>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>اسم القطعة</th>
                            <th>الكمية</th>
                            <th>سعر الوحدة</th>
                            <th>الخصم</th>
                            <th>الإجمالي</th>
                            <th>مورد القطعة</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($item->sparePart->getTranslation('name', 'ar') ?? '---'); ?></td>
                                <td><?php echo e($item->quantity); ?></td>
                                <td><?php echo e(number_format($item->unit_price, 2)); ?> ريال</td>
                                <td>
                                    <?php if($item->has_discount): ?>
                                        <?php echo e(number_format($item->discount_amount, 2)); ?> ريال
                                    <?php else: ?>
                                        لا يوجد
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e(number_format(($item->unit_price * $item->quantity) - $item->discount_amount, 2)); ?> ريال
                                </td>
                                <td><?php echo e($item->sparePart->vendor?->getTranslation('name','ar')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/order/show.blade.php ENDPATH**/ ?>