

<?php $__env->startSection('title', 'كل طلبات القطع'); ?>

<?php $__env->startSection('css'); ?>
<?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>طلبات القطع</h3>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المستخدم</th>
                                        <th>الهاتف</th>
                                        <th>الوصف</th>
                                        <th>الحالة</th>
                                        <th>العمليات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($i + 1); ?></td>
                                            <td><?php echo e($request->user?->full_name); ?></td>
                                            <td><?php echo e($request->user?->phone); ?></td>
                                            <td><?php echo e(Str::limit($request->description, 30)); ?></td>
                                            <td>
                                                <span class="badge bg-<?php echo e($request->status == 'pending' ? 'warning' : 'success'); ?>">
                                                    <?php echo e($request->status); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-info" data-bs-toggle="modal"
                                                        data-bs-target="#edit<?php echo e($request->id); ?>">
                                                    تحديث تتبع الطلب 
                                                </button>

                                                <a href="<?php echo e(route('admin.custom_parts.items', $request->id)); ?>"
                                                   class="btn btn-sm btn-primary">
                                                    عرض العناصر
                                                </a>
                                            </td>
                                        </tr>

                                        <!-- Modal -->
                                                                           <!-- Edit Order Modal -->
                                    <div class="modal fade" id="edit<?php echo e($request->id); ?>" tabindex="-1"
                                        aria-labelledby="editOrderModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editOrderModalLabel">تعديل الطلب</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form enctype="multipart/form-data" method="post"
                                                        action="<?php echo e(route('admin.custom_parts.update', $request->id)); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PATCH'); ?>
                                                        <div class="mb-3">
                                                            <label for="editStatus" class="form-label">الحالة</label>
                                                            <select class="form-control" id="editStatus" name="status"
                                                                required>
                                                                <option value="prepared" <?php echo e($request->status == 'prepared' ?
                                                                    'selected' : 'prepared'); ?>>تم التجهيز</option>
                                                                <option value="shipped" <?php echo e($request->status == 'shipped' ?
                                                                    'selected' : 'shipped'); ?>>تم الشحن</option>
                                                                <option value="ended" <?php echo e($request->status ==
                                                                    'ended' ?
                                                                    'selected' : 'ended'); ?>>تم التوصيل</option>
                                                                <option value="canceled" <?php echo e($request->status == 'canceled'
                                                                    ? 'selected' : ''); ?>>ملغي</option>
                                                            </select>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">إلغاء</button>
                                                            <button type="submit" class="btn btn-primary">حفظ
                                                                التغييرات</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/custompart/index.blade.php ENDPATH**/ ?>