<?php $__env->startSection('title'); ?>
    تفاصيل صفحات الموقع
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <?php echo $__env->make('admin.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script>
    <?php if(session('success')): ?>
        toastr.success("<?php echo e(session('success')); ?>");
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>

<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">تفاصيل صفحات الموقع</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('admin/dashboard')); ?>">الرئيسية / </a></li>
                        <li class="breadcrumb-item">صفحات الموقع</li>
                    </ol>
                </div>
            </div>
        </div>

        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.site_detail_update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="row">
                <?php $__currentLoopData = $site_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sectionKey => $sectionValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(in_array($sectionKey, ['message', 'setting', 'services'])): ?>
                        <?php continue; ?>
                    <?php endif; ?>

                    <div class="col-md-12 mb-5">
                        <div class="card p-3">
                            <h5 class="mb-3"><?php echo e($sectionKey); ?></h5>

                            <?php if(is_array($sectionValue) && isset($sectionValue[0]) && is_array($sectionValue[0])): ?>
                                <?php $__currentLoopData = $sectionValue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(isset($item['id']) && isset($item['key'])): ?>
                                    <div class="border p-3 mb-3">
                                        <input type="hidden" name="sections[<?php echo e($item['id']); ?>][key]" value="<?php echo e($item['key']); ?>">

                                        <div class="mb-2">
                                            <label>العنوان</label>
                                            <input type="text" class="form-control" name="sections[<?php echo e($item['id']); ?>][title]" value="<?php echo e($item['title'] ?? ''); ?>">
                                        </div>

                                        <div class="mb-2">
                                            <label>وصف قصير</label>
                                            <textarea class="form-control" name="sections[<?php echo e($item['id']); ?>][short_description]"><?php echo e($item['short_description'] ?? ''); ?></textarea>
                                        </div>

                                        <div class="mb-2">
                                            <label>المحتوى</label>
                                            <textarea class="form-control" name="sections[<?php echo e($item['id']); ?>][body]"><?php echo e($item['body'] ?? ''); ?></textarea>
                                        </div>

                                        <?php if(!empty($item['image'])): ?>
                                            <div class="mb-2">
                                                <label>صورة حالية:</label><br>
                                                <img src="<?php echo e($item['image']); ?>" alt="" style="max-width:150px;">
                                            </div>
                                        <?php endif; ?>

                                        <?php if(!empty($item['image2'])): ?>
                                            <div class="mb-2">
                                                <label>صورة 2:</label><br>
                                                <img src="<?php echo e($item['image2']); ?>" alt="" style="max-width:150px;">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php elseif(is_array($sectionValue) && isset($sectionValue['id']) && isset($sectionValue['key'])): ?>
                                <div class="border p-3 mb-3">
                                    <input type="hidden" name="sections[<?php echo e($sectionValue['id']); ?>][key]" value="<?php echo e($sectionValue['key']); ?>">

                                    <div class="mb-2">
                                        <label>العنوان</label>
                                        <input type="text" class="form-control" name="sections[<?php echo e($sectionValue['id']); ?>][title]" value="<?php echo e($sectionValue['title'] ?? ''); ?>">
                                    </div>

                                    <div class="mb-2">
                                        <label>وصف قصير</label>
                                        <textarea class="form-control" name="sections[<?php echo e($sectionValue['id']); ?>][short_description]"><?php echo e($sectionValue['short_description'] ?? ''); ?></textarea>
                                    </div>

                                    <div class="mb-2">
                                        <label>المحتوى</label>
                                        <textarea class="form-control" name="sections[<?php echo e($sectionValue['id']); ?>][body]"><?php echo e($sectionValue['body'] ?? ''); ?></textarea>
                                    </div>

                                    <?php if(!empty($sectionValue['image'])): ?>
                                        <div class="mb-2">
                                            <label>صورة حالية:</label><br>
                                            <img src="<?php echo e($sectionValue['image']); ?>" alt="" style="max-width:150px;">
                                        </div>
                                    <?php endif; ?>

                                    <?php if(!empty($sectionValue['image2'])): ?>
                                        <div class="mb-2">
                                            <label>صورة 2:</label><br>
                                            <img src="<?php echo e($sectionValue['image2']); ?>" alt="" style="max-width:150px;">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

           
       

        
       <!-- جزء عرض وتعديل الخدمات -->
            <div class="col-md-12 mb-5">
                <div class="card p-3">
                    <h5 class="mb-3">الخدمات</h5>

                    
                    <?php if(isset($site_details['services']) && is_array($site_details['services'])): ?>
                        <?php $__currentLoopData = $site_details['services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="border p-3 mb-3">
                                <input type="hidden" name="services[<?php echo e($index); ?>][id]" value="<?php echo e($service['id'] ?? ''); ?>">

                                <div class="mb-2">
                                    <label>الوصف المختصر</label>
                                    <input type="text" name="services[<?php echo e($index); ?>][short_text]" class="form-control"
                                        value="<?php echo e($service['short_text'] ?? ''); ?>">
                                </div>

                                <div class="mb-2">
                                    <label>الصورة</label>
                                    <?php if(!empty($service['image'])): ?>
                                        <div class="mb-2">
                                            <img src="<?php echo e($service['image']); ?>" alt="Service Image" style="max-width: 120px;">
                                        </div>
                                    <?php endif; ?>
                                    <input type="file" name="services[<?php echo e($index); ?>][image]" class="form-control">
                                </div>

                                
                                <div class="mb-2">
                                    <button type="submit" formaction=""
                                            class="btn btn-danger btn-sm"
                                            onclick="return confirm('هل أنت متأكد من حذف هذه الخدمة؟')">
                                        حذف
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    
                    <div class="border p-3 mt-4">
                        <h6>إضافة خدمة جديدة</h6>
                        <div class="mb-2">
                            <label>الوصف المختصر</label>
                            <input type="text" name="new_service[short_text]" class="form-control">
                        </div>
                        <div class="mb-2">
                            <label>الصورة</label>
                            <input type="file" name="new_service[image]" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
             <div class="text-end">
                <button class="btn btn-primary">حفظ التغييرات</button>
            </div>
      </form>   

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php echo $__env->make('admin.layouts.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dujgimmy/app2.part-mart.net/resources/views/admin/pages/site-details/index.blade.php ENDPATH**/ ?>