@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<script>
    @if(session('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(session('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>

<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;"> سياسة وخصوصية الموقع </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">الرئيســـــية</a></li>
                        <li class="breadcrumb-item"> <a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">سياسة وخصوصية الموقع </a> </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <!-- Bookmark Start-->
                    <div class="bookmark">
                    </div>
                    <!-- Bookmark Ends-->
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;"> سياسة وخصوصية الموقع </h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" method="POST" action="{{ route('terms.store') }}"
                            enctype="multipart/form-data">
                            @csrf
                            <!-- Include hidden field for ID if editing -->

                            <div class="col-sm-12 col-xl-12 xl-100">
                                <div class="card">
                                    <div class="card-body">
                                        <ul class="nav nav-tabs" id="icon-tab" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link active" id="icon-home-tab" data-bs-toggle="tab"
                                                    href="#icon-home" role="tab" aria-controls="icon-home"
                                                    aria-selected="true"
                                                    style="font-family: 'Cairo', sans-serif;">اللغـــة العربية</a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" id="profile-icon-tab" data-bs-toggle="tab"
                                                    href="#profile-icon" role="tab" aria-controls="profile-icon"
                                                    aria-selected="false"
                                                    style="font-family: 'Cairo', sans-serif;">اللغـــة الانجليزيـــة</a>
                                            </li>
                                        </ul>
                                        <br>
                                        <div class="tab-content" id="icon-tabContent">
                                            <!-- Arabic Tab -->
                                            <div class="tab-pane fade show active" id="icon-home" role="tabpanel"
                                                aria-labelledby="icon-home-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-12">
                                                        <label class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">النص الطويل باللغة
                                                            العربية</label>
                                                        <textarea name="terms_long_ar" class="form-control" rows="5"
                                                            id="editor2" style="border:solid 1px #555;" required>
                                                        </textarea>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="col-md-12">
                                                    <label class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">النص القصير باللغة
                                                        العربية</label>
                                                    <input name="terms_short_ar" class="form-control"
                                                        style="border:solid 1px #555" type="text" required>
                                                </div>
                                            </div>

                                            <!-- English Tab -->
                                            <div class="tab-pane fade" id="profile-icon" role="tabpanel"
                                                aria-labelledby="profile-icon-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-12">
                                                        <label class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">النص الطويل باللغة
                                                            الإنجليزية</label>
                                                        <textarea name="terms_long_en" class="form-control" rows="5"
                                                            id="editor1" style="border:solid 1px #555;" required>
                                                        </textarea>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="col-md-12">
                                                    <label class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">النص القصير باللغة
                                                        الإنجليزية</label>
                                                    <input name="terms_short_en" class="form-control"
                                                        style="border:solid 1px #555" type="text" required>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            @can('admin.terms_conditions.edit')
                            <button class="btn btn-primary mt-3" type="submit">حفـــظ</button>
                            @endcan
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
<!-- latest jquery -->
<script>
    ClassicEditor
    .create(document.querySelector('#editor1')) // المحرر العربي
    .catch(error => {
        console.error(error);
    });

ClassicEditor
    .create(document.querySelector('#editor2')) // المحرر الإنجليزي
    .catch(error => {
        console.error(error);
    });

</script>
@include('dashboard.layouts.js')

@endsection